/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse mèl :
	BILLARD, non joignable par mèl ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant à visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef VIBRATION_H
#define VIBRATION_H

#include <visu_data.h>

gboolean vibrationInit(VisuData *data, guint n, guint nNodes);
gboolean vibrationGet_nPhonons(VisuData *data, guint *n);
gboolean vibrationSet_currentMode(VisuData *data, guint iph, GError **error);
gboolean vibrationSet_displacements(VisuData *data, guint iph,
				    float *vibes, gboolean complex);
gboolean vibrationSet_characteristic(VisuData *data, guint n,
				     float q[3], float en, float omega);
gboolean vibrationGet_characteristic(VisuData *data, guint n,
				     float q[3], float *en, float *omega);
void vibrationSet_userFrequency(VisuData *data, float freq);
guint vibrationGet_currentMode(VisuData *data);

/**
 * startPlay:
 *
 * Initialize and add some properties for phonons as omega 
 * and delta for phonons toolpanel.
 * Also launch the timer with a random ID.
 *
 * @delta : the value of the timer
 *
 * Returns: the timer's ID
 */
guint vibrationStart_play(VisuData *data);

/**
 * stopPlay:
 *
 * Stop the timer with the given ID.
 *
 * Returns: a boolean.
 */
gboolean vibrationStop_play(guint timeoutID);

/**
 * resetPosition:
 *
 * Reset the node position of the given VisuData.
 *
 * Returns: a boolean
 */
void vibrationReset_position(VisuData *data);
void vibrationSet_zeroTime(VisuData *data);
gboolean vibrationSet_amplitude(VisuData *data, float ampl);

/**
 * spinbuild_list:
 *
 * make a new list to make OpenGl know that he draw spins or not.
 *
 */
void vibrationBuild_listSpin(VisuData *data);

/**
 * vibrationSet_useSpin:
 *
 * tells openGl if he has to draw the spin/phonons list
 *
 * @value : the value of the checkbox that allow to draw spin or not;
 */
gboolean vibrationSet_useSpin(gboolean value);

gboolean vibrationIsSet(VisuData *data);

gboolean vibrationSet(VisuData *data, float q[3], float en, float omega, float *vibes);

#endif
