/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Damien CALISTE, Tristan
	BERTHELOT, laboratoire L_Sim, (2001-2010)
  
	Adresse ml :
	CALISTE, damien P caliste AT cea P fr.
	BERTHELOT, tristan P berthelot AT isen P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors: Damien CALISTE, Tristan
	BERTHELOT, L_Sim laboratory, (2001-2010)

	E-mail address:
	CALISTE, damien P caliste AT cea P fr.
	BERTHELOT, tristan P berthelot AT isen P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at
        Documentation/licence.en.txt.
*/

#include <glib.h>
#include <gtk/gtk.h>

#include <Python.h>

#include <visu_basic.h>
#include <visu_gtk.h>
#include <coreTools/toolOptions.h>
#include <extraGtkFunctions/gtk_toolPanelWidget.h>
#include <visu_commandLine.h>

#define PYTHONGI_DESCRIPTION _("<span size=\"smaller\">"		\
			       "This plug-in allows to execute\n"	\
			       "Python scripts using GObject\n"		\
			       "introspection.</span>")
#define PYTHONGI_AUTHORS     "Caliste Damien &\nTristan Berthelot"


/* Local variables. */
static gchar *iconPath;
static GtkWidget *panelPython, *pyFileChooser, *pyExecute;
static gboolean isPanelInitialised;

/* Local methods. */
static void initialisePanel(ToolPanel *panel);
static gboolean loadScript(gpointer file);

/* Callbacks. */
static void onPanelEnter(ToolPanel *panel, gpointer data);
static void onScriptChosen(GtkFileChooserButton *widget, gpointer user_data);
static void onScriptExecute(GtkButton *widget, gpointer user_data);

gboolean pythongiInit(void)
{
  /* Long description */
  gchar *cl = _("Python scripting");
  /* Short description */
  gchar *tl = _("Python");
  GHashTable *options;
  ToolOption *opt;
  const gchar *file;

  iconPath = g_build_filename(V_SIM_PIXMAPS_DIR, "pythongi.png", NULL);

  panelPython = toolPanelNew_withIconFromPath("Panel_python", cl,
                                              tl, "stock-pythongi_20.png");
  toolPanelSet_dockable(TOOL_PANEL(panelPython), TRUE);
  toolPanelAttach(TOOL_PANEL(panelPython), toolPanelClassGet_commandPanel());

  isPanelInitialised = FALSE;
  g_signal_connect(G_OBJECT(panelPython), "page-entered",
		   G_CALLBACK(onPanelEnter), (gpointer)0);
  options = commandLineGet_options();
  if (options && (opt = (ToolOption*)g_hash_table_lookup(options, "pyScript")))
    {
      initialisePanel(TOOL_PANEL(panelPython));
      file = g_value_get_string(tool_option_getValue(opt));
      gtk_file_chooser_select_filename(GTK_FILE_CHOOSER(pyFileChooser), file);
      gtk_widget_set_sensitive(pyExecute, TRUE);
      g_idle_add_full(G_PRIORITY_LOW, loadScript, (gpointer)file, NULL);
    }

  return TRUE;
}
const char* pythongiGet_description(void)
{
  return PYTHONGI_DESCRIPTION;
}

const char* pythongiGet_authors(void)
{
  return PYTHONGI_AUTHORS;
}

const char* pythongiGet_icon(void)
{
  return iconPath;
}

static void onPanelEnter(ToolPanel *panel, gpointer data _U_)
{
  DBG_fprintf(stderr, "Panel PythonGI: caught the 'page-entered' signal %d.\n",
	      isPanelInitialised);
  if (!isPanelInitialised)
    initialisePanel(panel);
}
static void initialisePanel(ToolPanel *panel)
{
  GtkWidget *vbox, *hbox, *wd;
  GtkFileFilter *flt;

  g_return_if_fail(!isPanelInitialised);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(panel), vbox);

  wd = gtk_label_new(_("<b>Interactive scripting</b>"));
  gtk_label_set_use_markup(GTK_LABEL(wd), TRUE);
  gtk_misc_set_alignment(GTK_MISC(wd), 0., 0.5);
  gtk_widget_set_name(wd, "label_head");
  gtk_box_pack_start(GTK_BOX(vbox), wd, FALSE, FALSE, 0);

  hbox = gtk_hbox_new(FALSE, 3);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 3);
  wd = gtk_label_new(_("Load:"));
  gtk_misc_set_padding(GTK_MISC(wd), 5, 0);
  gtk_box_pack_start(GTK_BOX(hbox), wd, FALSE, FALSE, 0);
  pyFileChooser = gtk_file_chooser_button_new(_("Choose a Python script"),
					      GTK_FILE_CHOOSER_ACTION_OPEN);
  flt = gtk_file_filter_new();
  gtk_file_filter_set_name(flt, _("Python scripts for V_Sim"));
  gtk_file_filter_add_mime_type(flt, "text/x-script.python");
  gtk_file_filter_add_mime_type(flt, "text/x-python");
  gtk_file_filter_add_mime_type(flt, "application/x-python");
  gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(pyFileChooser), flt);
  flt = gtk_file_filter_new();
  gtk_file_filter_set_name(flt, _("All"));
  gtk_file_filter_add_pattern(flt, "*");
  gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(pyFileChooser), flt);
  gtk_box_pack_start(GTK_BOX(hbox), pyFileChooser, TRUE, TRUE, 0);
  pyExecute = gtk_button_new_from_stock(GTK_STOCK_EXECUTE);
  gtk_widget_set_sensitive(pyExecute, FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), pyExecute, FALSE, FALSE, 0);

  g_signal_connect(G_OBJECT(pyFileChooser), "file-set",
		   G_CALLBACK(onScriptChosen), (gpointer)pyExecute);
  g_signal_connect(G_OBJECT(pyExecute), "clicked",
		   G_CALLBACK(onScriptExecute), (gpointer)pyFileChooser);
  
  gtk_widget_show_all(vbox);

  Py_Initialize();
  PyRun_SimpleString("import os;"
                     "os.putenv(\"GI_TYPELIB_PATH\", \"" VISU_TYPELIBS_DIR "\");"
                     "import sys;"
                     "sys.path = [\"" VISU_EXEC_DIR "\"] + sys.path;"
                     "sys.argv = ['']");
  DBG_fprintf(stderr, "Panel PythonGI: import sys.\n"
              "sys.path = [\"" GI_TYPELIBS_DIR "\"] + sys.path;\n"
              "sys.path = [\"" PYGI_EXEC_DIR "\"] + sys.path;\n"
              "import os;\n"
              "os.putenv(\"GI_TYPELIB_PATH\", \"" VISU_TYPELIBS_DIR "\");\n"
              "sys.path = [\"" VISU_EXEC_DIR "\"] + sys.path\n");

  isPanelInitialised = TRUE;
}

static void onScriptChosen(GtkFileChooserButton *widget, gpointer user_data)
{
  gchar *file;

  file = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(widget));
  gtk_widget_set_sensitive(GTK_WIDGET(user_data), (file != (gchar*)0));
  if (file)
    g_free(file);
}
static void onScriptExecute(GtkButton *widget _U_, gpointer user_data)
{
  gchar *file;

  file = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(user_data));
  g_return_if_fail(file);

  g_idle_add_full(G_PRIORITY_DEFAULT_IDLE, loadScript, (gpointer)file, g_free);
}


static gboolean loadScript(gpointer file)
{
  gchar *script;
  GError *error;

  DBG_fprintf(stderr, "Panel PythonGI: load script '%s'.\n", (gchar*)file);
  error = (GError*)0;
  if (!g_file_get_contents((gchar*)file, &script, (gsize*)0, &error))
    {
      visuGtkRaise_warning(_("Load a Python script"), error->message,
			   toolPanelGet_containerWindow(TOOL_PANEL(panelPython)));
      g_error_free(error);
      return FALSE;
    }

  PyRun_SimpleString(script);
  g_free(script);

  return FALSE;
}
