/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2008  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valacreationmethod.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <vala/valavoidtype.h>
#include <vala/valacodevisitor.h>
#include <vala/valaformalparameter.h>
#include <vala/valadatatype.h>
#include <vala/valablock.h>
#include <vala/valatypesymbol.h>
#include <vala/valastruct.h>
#include <vala/valacodegenerator.h>




struct _ValaCreationMethodPrivate {
	char* _type_name;
	gint _n_construction_params;
};

#define VALA_CREATION_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CREATION_METHOD, ValaCreationMethodPrivate))
enum  {
	VALA_CREATION_METHOD_DUMMY_PROPERTY,
	VALA_CREATION_METHOD_TYPE_NAME,
	VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS
};
static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_creation_method_real_get_default_cname (ValaMethod* base);
static ValaCodeBinding* vala_creation_method_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen);
static gpointer vala_creation_method_parent_class = NULL;
static void vala_creation_method_dispose (GObject * obj);



/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod* vala_creation_method_new (const char* type_name, const char* name, ValaSourceReference* source_reference) {
	ValaCreationMethod * self;
	ValaVoidType* _tmp0;
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_CREATION_METHOD, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	vala_creation_method_set_type_name (self, type_name);
	_tmp0 = NULL;
	vala_method_set_return_type (VALA_METHOD (self), VALA_DATA_TYPE ((_tmp0 = vala_void_type_new ())));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	return self;
}


static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_creation_method (visitor, self);
}


static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (VALA_METHOD (self));
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				vala_code_node_accept (VALA_CODE_NODE (param), visitor);
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
	}
	{
		GeeList* error_type_collection;
		int error_type_it;
		error_type_collection = vala_code_node_get_error_types (VALA_CODE_NODE (self));
		for (error_type_it = 0; error_type_it < gee_collection_get_size (GEE_COLLECTION (error_type_collection)); error_type_it = error_type_it + 1) {
			ValaDataType* error_type;
			error_type = ((ValaDataType*) (gee_list_get (GEE_LIST (error_type_collection), error_type_it)));
			{
				vala_code_node_accept (VALA_CODE_NODE (error_type), visitor);
				(error_type == NULL ? NULL : (error_type = (g_object_unref (error_type), NULL)));
			}
		}
		(error_type_collection == NULL ? NULL : (error_type_collection = (g_object_unref (error_type_collection), NULL)));
	}
	if (vala_method_get_body (VALA_METHOD (self)) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_method_get_body (VALA_METHOD (self))), visitor);
	}
}


static char* vala_creation_method_real_get_default_cname (ValaMethod* base) {
	ValaCreationMethod * self;
	ValaTypeSymbol* _tmp1;
	ValaSymbol* _tmp0;
	ValaTypeSymbol* parent;
	char* infix;
	self = VALA_CREATION_METHOD (base);
	_tmp1 = NULL;
	_tmp0 = NULL;
	parent = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol (VALA_SYMBOL (self)), (VALA_IS_TYPESYMBOL (_tmp0) ? ((ValaTypeSymbol*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	infix = g_strdup ("new");
	if (VALA_IS_STRUCT (parent)) {
		char* _tmp2;
		_tmp2 = NULL;
		infix = (_tmp2 = g_strdup ("init"), (infix = (g_free (infix), NULL)), _tmp2);
	}
	if (g_utf8_strlen (vala_symbol_get_name (VALA_SYMBOL (self)), -1) == g_utf8_strlen (".new", -1)) {
		char* _tmp3;
		char* _tmp4;
		char* _tmp5;
		_tmp3 = NULL;
		_tmp4 = NULL;
		_tmp5 = NULL;
		return (_tmp5 = (_tmp4 = g_strdup_printf ("%s%s", (_tmp3 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (parent))), infix), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4), (parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL))), (infix = (g_free (infix), NULL)), _tmp5);
	} else {
		char* _tmp6;
		char* _tmp7;
		char* _tmp8;
		_tmp6 = NULL;
		_tmp7 = NULL;
		_tmp8 = NULL;
		return (_tmp8 = (_tmp7 = g_strdup_printf ("%s%s_%s", (_tmp6 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (parent))), infix, g_utf8_offset_to_pointer (vala_symbol_get_name (VALA_SYMBOL (self)), g_utf8_strlen (".new.", -1))), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7), (parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL))), (infix = (g_free (infix), NULL)), _tmp8);
	}
	(parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL)));
	infix = (g_free (infix), NULL);
}


static ValaCodeBinding* vala_creation_method_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (base);
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (codegen), NULL);
	return vala_code_generator_create_creation_method_binding (codegen, self);
}


const char* vala_creation_method_get_type_name (ValaCreationMethod* self) {
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (self), NULL);
	return self->priv->_type_name;
}


void vala_creation_method_set_type_name (ValaCreationMethod* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CREATION_METHOD (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_type_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_type_name = (g_free (self->priv->_type_name), NULL)), _tmp2);
}


gint vala_creation_method_get_n_construction_params (ValaCreationMethod* self) {
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (self), 0);
	return self->priv->_n_construction_params;
}


void vala_creation_method_set_n_construction_params (ValaCreationMethod* self, gint value) {
	g_return_if_fail (VALA_IS_CREATION_METHOD (self));
	self->priv->_n_construction_params = value;
}


static void vala_creation_method_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (object);
	switch (property_id) {
		case VALA_CREATION_METHOD_TYPE_NAME:
		g_value_set_string (value, vala_creation_method_get_type_name (self));
		break;
		case VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS:
		g_value_set_int (value, vala_creation_method_get_n_construction_params (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_creation_method_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (object);
	switch (property_id) {
		case VALA_CREATION_METHOD_TYPE_NAME:
		vala_creation_method_set_type_name (self, g_value_get_string (value));
		break;
		case VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS:
		vala_creation_method_set_n_construction_params (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_creation_method_class_init (ValaCreationMethodClass * klass) {
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCreationMethodPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_creation_method_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_creation_method_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_creation_method_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_creation_method_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_creation_method_real_accept_children;
	VALA_METHOD_CLASS (klass)->get_default_cname = vala_creation_method_real_get_default_cname;
	VALA_CODE_NODE_CLASS (klass)->create_code_binding = vala_creation_method_real_create_code_binding;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CREATION_METHOD_TYPE_NAME, g_param_spec_string ("type-name", "type-name", "type-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS, g_param_spec_int ("n-construction-params", "n-construction-params", "n-construction-params", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_creation_method_instance_init (ValaCreationMethod * self) {
	self->priv = VALA_CREATION_METHOD_GET_PRIVATE (self);
}


static void vala_creation_method_dispose (GObject * obj) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (obj);
	self->priv->_type_name = (g_free (self->priv->_type_name), NULL);
	G_OBJECT_CLASS (vala_creation_method_parent_class)->dispose (obj);
}


GType vala_creation_method_get_type (void) {
	static GType vala_creation_method_type_id = 0;
	if (G_UNLIKELY (vala_creation_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init };
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	}
	return vala_creation_method_type_id;
}




