/***************************************************************************
                          dcdebug.h  -  description
                             -------------------
    begin                : Don Sep 25 2003
    copyright            : (C) 2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCDEBUG_H
#define DCDEBUG_H

#include <qtimer.h>

#include <dclib/core/cstring.h>

#include <DCDialogDebug.h>

/**
  *@author Mathias Kster
  */

class CHttp;

class DCDebug : public DCDialogDebug  {
Q_OBJECT

public: 
	/** construtor */
	DCDebug(QWidget *parent=0, const char *name=0);
	/** destructor */
	virtual ~DCDebug();

	/** */
	void InitDocument();
	/** */
	bool Init( QString configpath, QString debugopt );

	/** */
	static CString arg_0;
	/** */
	static CString startup_dir;


private slots:
	/** */
	void slotSendBacktrace();
	/** */
	void slotSaveBacktrace();
	/** */
	void timerDone();

private:
	/** */
	QString m_sBuffer;
	/** */
	CHttp * m_pHttp;
	/** */
	QTimer m_Timer;
	/** */
	bool m_bTransfer;

	/** http callback function */
	int HttpCallBack( CObject *, CObject * );
};

#define DEBUGGERRC	"debuggerrc"

#ifndef WIN32
	/** */
	void crash_install_handlers(void);
	/** */
	void crash_main(const char *arg); 
#endif

#endif
