/*
databox Form
header file: databox.h
*/
#ifndef _databox_form_h_
#define _databox_form_h_
#include <vdk/vdk.h>
#ifndef PI
#define PI 3.14159265358979323846
#endif
#define CHECKS	7
#define POINTS	2000
// Databox FORM  CLASS
class DataboxForm: public VDKForm
{
// gui object declarations
private:
  VDKCheckButton *_check[CHECKS];
  VDKColor *_red;
  VDKColor *_green;
  gfloat _lissajousX[POINTS];
  gfloat _lissajousY[POINTS];
  gfloat _lissajousFrequency;
  gint _lissajousCounter;
// vdkbuilder reserved gui construction
	void GUISetup(void);

public:
	DataboxForm(VDKForm* owner, char* title);
	~DataboxForm();
	void Setup(void);
	bool OnToggle(VDKObject *obj);
	static gint OnIdle(gpointer data);
	bool CanClose();
	static VDKForm* Create(VDKForm* owner)
	{ 
	return new DataboxForm(owner,NULL);
	}


/*
 gui setup include 
 do not patch below here
*/
#include <databox_gui.h>
};
#endif