/* Taken and adapted from the tetris plugin,
   (c) Clemens Kirchgatterer <clemens@thf.ath.cx> 2002   
*/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <vdr/config.h>
#include "display.h"

#include "setup.h"


#define MINX  36
#define MINY  16
#define MAXX 685
#define MAXY 543


static int width, height, bpp, messageWidth;
static DisplayMode displayMode;
static eDvbColor currentBackground=clrBackground;


static cOsdBase      *osd = NULL;
static tWindowHandle  win = -1;

static eDvbColor
DisplayColor(Color col) {
   switch (col) {
      case BGR: return (clrBackground);
      case RED: return (clrRed);
      case GRN: return (clrGreen);
      case BLU: return (clrBlue);
      case YEL: return (clrYellow);
      case MAG: return (clrMagenta);
      case CYN: return (clrCyan);
      case WHT: return (clrWhite);
      case BLK: return (clrBlack);
      case TRS: return (clrTransparent);
   }
   return (clrWhite);
}


int 
DisplayOpen(int Bpp, DisplayMode mode) {
   //int s=2;
   //size    = s*4+4;
   bpp=Bpp;
   displayMode=mode;
   //width   = 10*size;
   //width=w;  //must be a product of 4
   //height=h; 
   height=ttSetup.OSDheight * cOsd::LineHeight();
   width=ttSetup.OSDwidth * cOsd::CellWidth();
   messageWidth=0;

   int xpos, ypos;

   if (osd) return (-1);
   
   //this was the old solution from tetris. x,y  [-8;0] for reasonable results
//   xpos = MINX+(int)((MAXX-width-MINX)*((x+9.0)/18.0));
//   ypos = MINY+(int)((MAXY-height-MINY)*((y+9.0)/18.0));
   //new solution taken from osd.c
   xpos = (720 - width) / 2; 
   ypos = (576 - height) / 2 ;   
   if (mode == HalfLower || mode== HalfUpper) {
      height /= 2;
      height -= (height%4);
      ypos += height;
   }
   
   osd = cOsd::OpenRaw(xpos, ypos);
   if (!osd) {
      cOsd::Close();
      osd = cOsd::OpenRaw(xpos, ypos);
      if (!osd) {
         return (-1);
      }
   }
   win = osd->Create(0, 0, width, height, Bpp);
   
   if (bpp == 2) {
      //the 3+1 colors for large OSD. Must correspond with cTxtBitmap::TranslateColor
      osd->AddColor(COLORMAPPING_2_COLOR1);
      osd->AddColor(COLORMAPPING_2_COLOR2);
      osd->AddColor(COLORMAPPING_2_COLOR3);
      osd->AddColor(COLORMAPPING_2_COLOR4);
   } else { //Bpp == 3  => 8 colors
      osd->AddColor(COLORMAPPING_3_COLOR1);
      //osd->AddColor(clrTransparent);
      osd->AddColor(COLORMAPPING_3_COLOR2);
      osd->AddColor(COLORMAPPING_3_COLOR3);
      osd->AddColor(COLORMAPPING_3_COLOR4);
      osd->AddColor(COLORMAPPING_3_COLOR5);
      osd->AddColor(COLORMAPPING_3_COLOR6);
      osd->AddColor(COLORMAPPING_3_COLOR7);
      //osd->AddColor(clrBlack);
      osd->AddColor(COLORMAPPING_3_COLOR8);
   }
   
   //osd->SetFont(fontFix);
   osd->Show(win);
   osd->Flush();
   
   ////Make the last line, which is for messages, fully transparent
   //DisplayClearMessage();   
   //osd->Flush();
   
   return (0);
}


int
DisplayClose(void) {
   if (!osd) return (-1);
   osd->Clear(win);
   osd->Hide(win);
   osd->Flush();
   delete (osd);
   osd = NULL;
   return (0);
}

int  DisplayCheckMode(int Bpp, DisplayMode mode) {
   if (osd && displayMode != mode) {
      if ( (displayMode==Full || displayMode==ZoomUpper || displayMode==ZoomLower) && (mode==HalfUpper || mode==HalfLower) 
          || (mode==Full || mode==ZoomUpper || mode==ZoomLower) && (displayMode==HalfUpper || displayMode==HalfLower)  ) {
         DisplayClose();
         return DisplayOpen(Bpp, mode);
      } else {
         displayMode=mode; //no need to reopen if size does not change
         return 0;
      }
   } else if (!osd)
      return DisplayOpen(Bpp, mode);
   else
      return 0;
}

int
DisplayWidth(void) {
   return (width);
}

int
DisplayHeight(void) {
   return (height);
}

int
DisplayFontHeight(void) {
   return (24);
}

int
DisplayCharWidth(char c) {
   if (osd) {
      return (osd->Width(c));
   }
   return (-1);
}

int
DisplayStringWidth(const char *s) {
   if (osd) {
      return (osd->Width(s));
   }
   return (-1);
}

void
DisplayPrintText(int x, int y, const char *txt) {
   if (osd) {
      osd->Text(x, y, txt);
   }
}

void
DisplayDrawBlock(int x, int y, Color col) {
   int x1, y1, x2, y2, size=2*4+4;

   x1 = x*size;
   y1 = y*size;
   x2 = x*size+size;
   y2 = y*size+size;
   if (osd) {
      osd->Fill(x1, y1, x2, y2, DisplayColor(col), win);
   }
}

void DisplayDrawRect(int x1, int y1, int x2, int y2, Color col) {
   if (osd) {
      osd->Fill(x1, y1, x2, y2, DisplayColor(col), win);
   }
}

//quick overloading
void DisplayDrawRect(int x1, int y1, int x2, int y2, eDvbColor col) {
   if (osd) {
      osd->Fill(x1, y1, x2, y2, col, win);
   }
}


void DisplayDrawBitmap(int x, int y, const cBitmap &bitmap) {
   if (osd) {
      osd->SetBitmap(x, y, bitmap, win);
   }
}

void
DisplayClearBlock(int x, int y) {
   DisplayDrawBlock(x, y, BGR);
}

void DisplayMessage(const char *txt) {
   if (osd && txt) {
     /* int x = (width - osd->Width(txt)) / 2;
      if (x < 0)
         x = 0;      
      //osd->Text(x, messageRgn, txt, clrWhite, DisplayColor(col));
      */
      messageWidth=osd->Width(txt);
      osd->Text(0,0,txt, bpp==2 ? COLORMAPPING_WHITE_2 : COLORMAPPING_WHITE_3, bpp==2 ? COLORMAPPING_BLACK_2 : COLORMAPPING_BLACK_3);
   }
}

void DisplayClearMessage() {
   DisplayDrawRect(0, 0, messageWidth, cOsd::LineHeight(), bpp==2 ? COLORMAPPING_BLACK_2 : COLORMAPPING_BLACK_3);
}

void
DisplayUpdate() {
   if (osd) {
      osd->Flush();
   }
}

eDvbColor DisplayGetBackground() {
   return currentBackground;
}

void DisplaySetBackground(eDvbColor bg) {
   currentBackground=bg;
}


