/*
 *                   Vertex Model Assembler: Utilities
 */

#ifndef VMAUTILS_H
#define VMAUTILS_H

#include <sys/types.h>
#include <gtk/gtk.h>
#include "v3dmodel.h"

#ifndef gbool
# define gbool	guchar
#endif


/*
 *      Statistics structure for V3D models:
 */
typedef struct {

	gint type;		/* Model's type. */
	glong size;		/* Total memory size in bytes. */
	glong size_primitives;	/* Memory used by primitives. */
	glong size_lines;	/* Memory used by other data lines. */
	glong size_misc;	/* Memory used by other misc data. */

	gint primitives;	/* Total primitives. */
	gint lines;		/* Total lines. */

} vma_model_stats_struct;



extern const gchar *VMADefaultDataGlobalDir(void);
extern const gchar *VMATempName(
        const gchar *tmp_dir, const gchar *name_prefix
);
extern FILE *VMAMakeOpenTmpFile(
	gpointer core_ptr,
        const gchar *tmp_dir,   
        const gchar *name_prefix,
	gchar **new_path_rtn
);

extern gint VMATextFileToCList(
	GtkCList *clist, const gchar *path, GtkStyle *style
);
extern gint VMAModelGetStats(
	v3d_model_struct *model_ptr, vma_model_stats_struct *buf
);
extern void VMAReportGLError(gpointer core_ptr, gint error_code);
extern int VMAGetGLVersion(
	gpointer core_ptr, gint *gl_version_major, gint *gl_version_minor,
        const gchar **renderer,
        const gchar **vendor,
        const gchar **extensions
);
extern gbool VMAWriteProtectCheck(gpointer editor_ptr);
extern void VMAFunctionNotAvailable(gpointer editor_ptr, const gchar *name);


#endif	/* VMAUTILS_H */
