#!/usr/local/bin/python
#*******************************************************************************
#                                                                              *
#                                   Viewmol                                    *
#                                                                              *
#                                 D E M O . P Y                                *
#                                                                              *
#                 Copyright (c) Joerg-R. Hill, December 2000                   *
#                                                                              *
#*******************************************************************************
#
# $Id: demo.py,v 1.1 2000/12/10 15:04:03 jrh Exp $
# $Log: demo.py,v $
# Revision 1.1  2000/12/10 15:04:03  jrh
# Initial revision
#
#
import viewmol
import molecule
import spectrum
import atom
import element
import energylevels
import history
import label
import light

ON=viewmol.__dict__['ON']
OFF=viewmol.__dict__['OFF']
WIREMODEL=viewmol.__dict__['WIREMODEL']
STICKMODEL=viewmol.__dict__['STICKMODEL']
BALLMODEL=viewmol.__dict__['BALLMODEL']
CPKMODEL=viewmol.__dict__['CPKMODEL']
PERSPECTIVE=viewmol.__dict__['PERSPECTIVE']
LINE=viewmol.__dict__['LINE']
SURFACE=viewmol.__dict__['SURFACE']
ORTHO=viewmol.__dict__['ORTHO']
MO=molecule.__dict__['MO']
DENSITY=molecule.__dict__['DENSITY']
IP_LOG=molecule.__dict__['IP_LOG']
REACTANT=molecule.__dict__['REACTANT']
PRODUCT=molecule.__dict__['PRODUCT']
REACTION=viewmol.__dict__['REACTION']
ANIMATE=spectrum.__dict__['ANIMATE']
ARROWS=spectrum.__dict__['ARROWS']
GAUSSIANS=spectrum.__dict__['GAUSSIANS']

def rotate(mol, axis):
  n=0
  fps=viewmol.getFramesPerSecond()
  if fps>50.0:
    increment=2
  else:
    increment=5
  while n<180:
    mol.rotate(n*axis[0], n*axis[1], n*axis[2])
    viewmol.redraw()
    n=n+increment

def translate(mol, direction):
  n=0.0
  while n<10.0:
    mol.translate(n*direction[0], n*direction[1], n*direction[2])
    viewmol.redraw()
    n=n+0.5

def drawingModes(molecule):
  label1=label.label()
  label1.translate(-230, 230, 0)
  label1.text('Viewmol supports different representations')
  label2=label.label()
  label2.translate(-230, 210, 0)
  label2.text('such as wire frame models ...')
  viewmol.model(WIREMODEL)
  rotate(molecule, (1.0, 0.0, 0.0))
  label2.text('... stick models ...')
  viewmol.model(STICKMODEL)
  rotate(molecule, (0.0, 1.0, 1.0))
  label2.text('... ball-and-stick models ...')
  viewmol.model(BALLMODEL)
  rotate(molecule, (0.0, 0.0, 1.0))
  label2.text('... or CPK models.')
  viewmol.model(CPKMODEL)
  rotate(molecule, (1.0, 1.0, 0.0))
  label2.delete()
  label1.text('There is also a perspective mode.')
  viewmol.projection(PERSPECTIVE)
  rotate(molecule, (0.0, 1.0, 1.0))
  label1.text('And you can turn lights on and off and move them.')
  lights=viewmol.getLights()
  lights[0].switch(OFF)
  rotate(lights[1], (1.0, 1.0, 0.0))
  lights[1].rotate(0, 0, 0)
  lights[0].switch(ON)
  label1.text('You can also change drawing style and resolution.')
  viewmol.drawingMode(LINE)
  n=10
  while n<30:
    viewmol.sphereResolution(n)
    viewmol.redraw()
    n=n+1
  viewmol.drawingMode(SURFACE)
  viewmol.sphereResolution(10)
  label1.delete()
  viewmol.projection(ORTHO)
  viewmol.model(WIREMODEL)

def vibrations(molecule):
  label1=label.label()
  label1.translate(-230, 230, 0)
  label1.text('Viewmol can also show vibrational spectra.')
  viewmol.model(STICKMODEL)
  spectrum1=molecule.getSpectrum()
  spectrum1.show()
  spectrum1.mode(27)
  spectrum1.display(ANIMATE)
  rotate(molecule, (1.0, 0.0, 1.0))
  label1.text('Of course, it doesn\'t have to be animated.')
  spectrum1.display(ARROWS)
  spectrum1.style(GAUSSIANS)
  rotate(molecule, (0.0, 1.0, 0.0))
  spectrum1.deselect()
  del spectrum1
  label1.delete()

def MOs(molecule):
  label1=label.label()
  label1.translate(-230, -230, 0)
  label1.text('Viewmol can show energy levels and MOs ...')
  energylevel1=molecule.getEnergyLevels()
  energylevel1.show()
  energylevel1.selectMO(21)
  viewmol.isosurface(0.05)
  molecule.showElectrons(MO, 20, IP_LOG)
  rotate(molecule, (1.0, 1.0, 1.0))
  n=0.05
  while n>0.001:
    viewmol.isosurface(n)
    viewmol.redraw()
    n=n-0.001
  viewmol.isosurface(0.05)
  label1.text('... or the electron density.')
  del energylevel1
  molecule.showElectrons(DENSITY, 20, IP_LOG)
  rotate(molecule, (0.0, 1.0, 1.0))
  molecule.showElectrons(OFF)
  label1.delete()

def history(molecule):
  label1=label.label()
  label1.translate(-230, -230, 0)
  label1.text('Viewmol can show the history of an optimization.')
  history1=molecule.getHistory()
  history1.show()
  molecule.showForces(ON)
  n=1
  while n < 9:
    history1.iteration(n)
    rotate(molecule, (0.0, 0.0, 0.0))
    n=n+1
  molecule.showForces(OFF)
  del history1
  label1.delete()

def buildMolecule():
  molecule1=molecule.molecule()
  viewmol.model(STICKMODEL)
  molecule1.addAtom('C')
  viewmol.redraw()
  atoms=molecule1.getAtoms()
  molecule1.addAtom('H', atoms[0])
  molecule1.addAtom('C', atoms[0])
  molecule1.addAtom('C', atoms[0])
  label1=label.label()
  label1.translate(-230, 230, 0)
  label1.text('Viewmol can also be used to build molecules.')
  rotate(molecule1, (1.0, 1.0, 0.0))
  del atoms
  atoms=molecule1.getAtoms()
  molecule1.addAtom('O', atoms[3])
  molecule1.addAtom('N', atoms[3])
  del atoms
  atoms=molecule1.getAtoms()
  molecule1.addAtom('H', atoms[5])
  molecule1.addAtom('H', atoms[5])
  label1.translate(-230, 230, 0)
  rotate(molecule1, (1.0, 1.0, 0.0))
  molecule1.addAtom('H', atoms[2])
  molecule1.addAtom('H', atoms[2])
  label1.translate(-230, 230, 0)
  rotate(molecule1, (1.0, 1.0, 0.0))
  del atoms
  label1.delete()
  viewmol.delete(molecule1)

def solid():
  molecule1=viewmol.load('../gulp/urea.out')
  molecule1.unitCell(ON, 2.0, 2.0, 2.0)
  label1=label.label()
  label1.translate(-230, 230, 0)
  label1.text('Viewmol can handle solids.')
  rotate(molecule1, (1.0, 0.0, 0.0))
  label1.text('Miller planes can be displayed.')
  molecule1.millerPlane(ON, 1, 1, 0)
  rotate(molecule1, (0.0, 1.0, 0.0))
  label1.delete()
  viewmol.delete(molecule1)

def thermodynamics():
  molecule1=viewmol.load('../reaction/no.outmol')
  molecule1.rotate(90.0, 0.0, 0.0)
  molecule1.reaction(PRODUCT)
  label1=label.label()
  label1.translate(-230, 230, 0)
  label1.text('Viewmol can handle reaction thermodynamics.')
  text='Lets load a number of molecules: ' + molecule1.title()
  label2=label.label()
  label2.translate(-230, 210, 0)
  label2.text(text)
  translate(molecule1, (-1.5, 1.5, 0.0))
  molecule2=viewmol.load('../reaction/h2o.outmol')
  molecule2.reaction(PRODUCT)
  label1.translate(-230, 230, 0)
  text=text + ', ' + molecule2.title()
  label2.translate(-230, 210, 0)
  label2.text(text)
  translate(molecule2, (1.5, 1.5, 0.0))
  molecule3=viewmol.load('../reaction/i2.outmol')
  molecule3.rotate(90.0, 0.0, 0.0)
  molecule3.reaction(REACTANT)
  label1.translate(-230, 230, 0)
  text=text + ', ' + molecule3.title()
  label2.translate(-230, 210, 0)
  label2.text(text)
  translate(molecule3, (-1.5, -1.5, 0.0))
  molecule4=viewmol.load('../reaction/hno3.outmol')
  molecule4.reaction(REACTANT)
  label1.translate(-230, 230, 0)
  text=text + ', ' + molecule4.title()
  label2.translate(-230, 210, 0)
  label2.text(text)
  translate(molecule4, (1.5, -1.5, 0.0))
  molecule5=viewmol.load('../reaction/hio3.outmol')
  molecule5.reaction(PRODUCT)
  text=text + ', ' + molecule5.title()
  label1.translate(-230, 230, 0)
  label2.translate(-230, 210, 0)
  label2.text(text)
  viewmol.showThermodynamics(REACTION)
  label2.delete()
  label1.delete()

def main():
  molecule1=viewmol.load('../turbomole/control')
  drawingModes(molecule1)
  vibrations(molecule1)
  MOs(molecule1)
  history(molecule1)
  viewmol.delete(molecule1)
  buildMolecule()
  solid()
  thermodynamics()
  label1=label.label()
  label1.translate(-230, 230, 0)
  label1.text('That\'s it, folks!')

main()
