/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <SignalPort.h>

#include <Strings.h>
#include <VectorFont.h>

#include "../images/port.xpm"

QPixmap* SignalPort::pixmap_ = 0;

//-----------------------------------------------------------------
SignalPort::SignalPort( const QPoint& center )
    : Component( center )
{}

//-----------------------------------------------------------------
SignalPort::~SignalPort()
{}

//-----------------------------------------------------------------
const QString& SignalPort::getCatagory() const
  {
    return Strings::PortCatagory;
  }

//-----------------------------------------------------------------
const QString& SignalPort::getName() const
  {
    return Strings::SignalPortName;
  }

//-----------------------------------------------------------------
const QPixmap& SignalPort::getPixmap() const
  {
    if (!pixmap_)
      {
        pixmap_ = new QPixmap(port_xpm);
      }
    return *pixmap_;
  }

//-----------------------------------------------------------------
void SignalPort::initComponent()
{
  boundingRect_ = QRect(-10, -8, 20, 16);
  addNode(8,0, TRUE, FALSE);
  addAttribute( Strings::AttrPortImpedance, "Z", 50.0 );
}

//-----------------------------------------------------------------
void SignalPort::drawSymbol(QPainter* p)
{
  p->moveTo(8,0);
  p->lineTo(6,0);
  p->lineTo(0,-6);
  p->lineTo(-10,-6);
  p->lineTo(-10,6);
  p->lineTo(0,6);
  p->lineTo(6,0);
  QString txt;
  txt.setNum( node(0)->getNodeNumber() );
  p->save();
  p->setPen( Qt::black );
  p->translate( -4,0 );
  p->rotate( -getRotation() );
  VectorFont::instance()->drawText( txt, p, QPoint(-2,4) );
  p->restore();
}

//-----------------------------------------------------------------
bool SignalPort::initSweep()
{
  TReal z = z_;
  z_ = getAttributeValue( "Z" );
  node(0)->setImpedance( z_ );
  return (z_ != z);
}

//-----------------------------------------------------------------
void SignalPort::addToAdmittanceMatrix( TReal, Matrix* )
{
}
