
#include "dbqlineedit.moc.h"
#include <QValidator>

using namespace std;

DBQLineEdit::DBQLineEdit(QWidget *parent)
  : DBQScoreBox(parent)
{
  originalvalue="";

  layout=new QHBoxLayout();
  layout->setSpacing(4);
  layout->setMargin(0);
  // layout->setAlignment(Qt::AlignLeft);
  this->setLayout(layout);

  ee=new QLineEdit();
  layout->addWidget(ee);
  layout->setStretchFactor(ee,20);
  ee->setFrame(0);
  ee->setReadOnly(0);
  ee->setText(originalvalue.c_str());
  // ee->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::Preferred);
  
  valueline=new QLineEdit();
  valueline->setText("<nodata>");
  valueline->setFrame(0);
  valueline->setReadOnly(1);
  layout->addWidget(valueline);
  layout->setStretchFactor(valueline,2);
  valueline->hide();
 
  layout->insertStretch(-1,0);

  button_set=new QPushButton("set",this);
  layout->addWidget(button_set);
  button_revert=new QPushButton("revert",this);
  layout->addWidget(button_revert);
  
  QObject::connect(button_revert,SIGNAL(clicked()),this,SLOT(revertclicked()));
  QObject::connect(button_set,SIGNAL(clicked()),this,SLOT(setclicked()));
  QObject::connect(ee,SIGNAL(textEdited(const QString &)),this,SLOT(textedited(const QString &)));
}

void
DBQLineEdit::setValue(const DBscorevalue &val)
{
  originalvalue=val.v_string;
  ee->setText(originalvalue.c_str());
  f_originallyset=1;
  f_set=1;
  updateAppearance();
}

void
DBQLineEdit::setEditable(bool e)
{
  f_editable=e;
  updateAppearance();
}

void
DBQLineEdit::setIntValidator(int32 min,int32 max)
{
  QValidator *vv=new QIntValidator(min,max,this);
  ee->setValidator(vv);
}

void
DBQLineEdit::setDoubleValidator(double min,double max,int decimals)
{
  QDoubleValidator *vv=new QDoubleValidator(min,max,decimals,this);
  vv->setNotation(QDoubleValidator::StandardNotation);
  ee->setValidator(vv);
}

void
DBQLineEdit::updateAppearance()
{
  if (ee->text().toStdString()==originalvalue)
    f_dirty=0;
  else
    f_dirty=1;
  valueline->setText(ee->text());
  DBQScoreBox::updateAppearance();
  if (f_editable && f_set) {
    ee->show();
  }
  else {
    ee->hide();
  }
}

void
DBQLineEdit::revertclicked()
{
  f_dirty=0;
  f_set=f_originallyset;
  ee->setText(originalvalue.c_str());
  valueline->setText(originalvalue.c_str());
  updateAppearance();
}

void
DBQLineEdit::setclicked()
{
  if (f_set) f_set=0;
  else f_set=1;
  updateAppearance();
}

void
DBQLineEdit::textedited(const QString &)
{
  updateAppearance();
}

void
DBQLineEdit::getValue(DBscorevalue &val)
{
  val.v_string=ee->text().toStdString();
  return;
}
