/*
 * Copyright (c) 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

/*
 * TIFF to Raster conversion
 */


#ifndef iv_tiff_h
#define iv_tiff_h

#include <InterViews/enter-scope.h>

#include <InterViews/_enter.h>

class Bitmap;
class Raster;
class RasterAction;

class TIFFRaster {
public:
  static Raster* load(const char* filename, boolean make_gray = false);

  // bmarsch: 11 Nov 94: loading with dithering
  static Raster* loadDithered(const char* filename, boolean make_gray = false);

  // bmarsch: 11 Nov 94: a more general load function
  static int load(const char* filename,        // filename
                  Raster*& r, Bitmap*& b,      // returns raster or bitmap
                  boolean noBitmap = true,     // should return no bitmap
                  boolean dither = true);      // switch on/off dithering
};

#include <InterViews/_leave.h>

#endif
