/* (C) 1998 Justin Schoeman (justin@suntiger.ee.up.ac.za)*/
/* Based on capture.c by Koji OKAMURA */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <errno.h>
#include <unistd.h>
#include <signal.h>
#include <linux/soundcard.h>
#include "/usr/local/v4l/driver/videodev.h"
#include "/usr/local/v4l/driver/bttv.h"
#include "XJ.h"

struct video_mmap mm, mm2;
struct video_channel chan;
int frame=0;

pid_t pid_child;
int audioblock;
char* audiobuf;
int audiosamp;
int astr, dsp;

int fd, *ostr, ostrnum, ostrcur=0;
unsigned char* buf;
int width, height;
int f;
int fno;

char *v_name;

unsigned int thisframe, lastframe, firstframe=0xffffffff;

void videostop(int i)
{
 FILE *par;
 kill(pid_child, SIGINT);
 fprintf(stderr,"CTRL-C exiting ...\n");
 fprintf(stderr, "Captured frames: %d\n", fno);
 fprintf(stderr, "Total frames: %d\n", (int)((lastframe>>1)-(firstframe>>1)+1));
 fprintf(stderr, "Dropped frames: %d\n", (int)((lastframe>>1)-(firstframe>>1)+1-fno));
 fprintf(stderr, "Writing summary info...\n");
 munmap(buf, width * height * 4);
 lseek(ostr[0], 2*sizeof(height), SEEK_SET);
 write(ostr[0], &lastframe, sizeof(lastframe));
 close(fd);

 fprintf(stderr, "Writing str2mpeg.par\n");
 par=fopen("str2ppm.par","w");
 fprintf(par, "MPEG-1 Test Sequence, 25 frames/sec\n");
 fprintf(par, "video:%%06d\n");
 fprintf(par, "-\n");
 fprintf(par, "-\n");
 fprintf(par, "-\n");
 fprintf(par, "-\n");
 fprintf(par, "3\n");
 fprintf(par, "%d\n", (int)((lastframe>>1)-(firstframe>>1)+1));
 fprintf(par, "0\n");
 fprintf(par, "00:00:00:00\n");
 fprintf(par, "12\n");
 fprintf(par, "3\n");
 fprintf(par, "1\n");
 fprintf(par, "0\n");
 fprintf(par, "%d\n", width);
 fprintf(par, "%d\n", height);
 fprintf(par, "8\n");
#ifdef NTSC
 fprintf(par, "5\n"); /* NTSC 30fps */
#else
 fprintf(par, "3\n"); /* PAL 25fps */
#endif
 fprintf(par, "%f\n", (float)width*height*12);
 fprintf(par, "20\n");
 fprintf(par, "0\n");
 fprintf(par, "1\n");
 fprintf(par, "4\n");
 fprintf(par, "8\n");
 fprintf(par, "1\n");
 fprintf(par, "1\n");
 fprintf(par, "1\n");
 fprintf(par, "5\n");
 fprintf(par, "5\n");
 fprintf(par, "5\n");
 fprintf(par, "%d\n", width);
 fprintf(par, "%d\n", height);
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "1 1 1\n");
 fprintf(par, "0 0 0\n");
 fprintf(par, "0 0 0\n");
 fprintf(par, "0 0 0\n");
 fprintf(par, "0 0 0\n");
 fprintf(par, "0\n");
 fprintf(par, "1\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "2 2 11 11\n");
 fprintf(par, "1 1 3  3\n");
 fprintf(par, "1 1 7  7\n");
 fprintf(par, "1 1 7  7\n");
 fprintf(par, "1 1 3  3\n");
 fclose(par);

 par=fopen("video:cliptab","a");
 if(!par)
 {
  perror("open cliptab");
  exit(-1);
 }
 fprintf(par, "B 0 0 %d\n", (int)((lastframe>>1)-(firstframe>>1)+1));
 fclose(par);
 
 XJ_exit();
 exit(0);
}

void audioalarm(int i)
{}

void audiostop(int i)
{
 close(dsp);
 close(astr);
 exit(0);
}

void usage(void)
{
 fprintf(stderr, "Usage:\n\n");
 fprintf(stderr, " stream [-half or -halfx Xxdim Xydim]\n");
 fprintf(stderr, "        [-start HH:MM:SS[:DD:MM:YYYY]] [-end HH:MM:SS[:DD:MM:YYYY]]\n    <xdim> <ydim> <audio stream> <video stream 1> [<video stream 2> ...]\n\n");
 exit(0);
}

time_t tc(char * buf)
{
 time_t ttime;
 int i,j,k,l,m,n,o;
 struct tm tms;
 
 ttime=time(NULL);
 tms=*localtime(&ttime);
 o=sscanf(buf, "%d:%d:%d:%d:%d:%d", &i, &j, &k, &l, &m, &n);
 tms.tm_hour=i;
 tms.tm_min=j;
 tms.tm_sec=k;
 if(o>3)tms.tm_mday=l;
 if(o>4)tms.tm_mon=m-1;
 if(o>5)tms.tm_year=n-1900;
 printf("%s", asctime(&tms));
 ttime=mktime(&tms);
 return ttime;
}

int main(int argc, char** argv)
{
  char *a_name;
  int half=0, i, X=0, Xwidth=0, Xheight=0;
  FILE *cliptab;
  time_t starttime=0, endtime=0, ntime; 
  char *sbuf=NULL;
  struct sigaction aqsig={audiostop, 0, SA_RESTART|SA_NOMASK, NULL};
  struct sigaction vqsig={videostop, 0, SA_RESTART|SA_NOMASK, NULL};
  struct sigaction asig={audioalarm, 0, SA_RESTART|SA_NOMASK, NULL};

  cliptab=fopen("video:cliptab","w");
  if(!cliptab)
  {
   perror("open cliptab");
   exit(-1);
  }
  
  for(i=1; (i<argc)&&(argv[i][0]=='-'); i++)
  {
    if(strcmp(argv[i],"-half")==0)
    {
     fprintf(stderr, "Recording at half rate.\n");
     half=1;
    } else if(strcmp(argv[i],"-halfx")==0)
    {
     if(argc<(i+3))usage();
     X=1;
     Xwidth=atoi(argv[++i]);
     Xheight=atoi(argv[++i]);
     fprintf(stderr, "Recording at half rate + Xdisplay (%dx%d).\n", Xwidth, Xheight);
     sbuf=XJ_init(Xwidth, Xheight, "Vstream", "Vstream");
#ifdef FIX32
     if(XJ_depth==24) XJ_depth=32;
#endif     
    }
    else if(strcmp(argv[i],"-start")==0)
    {
     if(argc<(i+2))usage();
     fprintf(stderr, "Start time: ");
     starttime=tc(argv[++i]);
     fprintf(stderr, "(1970=immediate).\n");
    } else if(strcmp(argv[i],"-end")==0)
    {
     if(argc<(i+2))usage();
     fprintf(stderr, "End time: ");
     endtime=tc(argv[++i]);
     fprintf(stderr, "(1970=immediate).\n");
    } else usage();
  }
  
  if(argc<(i+4))usage();
  width=atoi(argv[i++]);
  height=atoi(argv[i++]);
  fprintf(stderr, "Capture size: %dx%d .\n", width, height);
  a_name=argv[i];
  fprintf(stderr, "Capture audio to: %s .\n", argv[i]);
  fprintf(cliptab, "%s ", argv[i]);
  astr=open(argv[i++], O_RDWR|O_TRUNC|O_CREAT, S_IRUSR|S_IWUSR);
  ostrnum=argc-i;
  ostr=(int *)malloc(ostrnum*sizeof(int));
  if(!ostr)
  {
   perror("malloc ostr");
   exit(-1); 
  }
  fprintf(stderr, "Capture video to: ");
  for(;i<argc;i++)
  {
   fprintf(stderr, "%s ", argv[i]);
   fprintf(cliptab, "%s ", argv[i]);
   ostr[ostrcur]=open(argv[i], O_RDWR|O_TRUNC|O_CREAT, S_IRUSR|S_IWUSR);
   if(ostr[ostrcur++]<=0)
   {
    perror("open video file");
    exit(-1);
   }
  }
  ostrcur=0;  
  fprintf(stderr, "\n");
  fprintf(cliptab, "\n*\n");
  fclose(cliptab);
  
  fd = open("/dev/bttv0", O_RDWR);
  if(fd<=0){
    perror("open");
    exit(-1);
  }
  
  write(ostr[0], &width, sizeof(width));
  write(ostr[0], &height, sizeof(height));
  write(ostr[0], &firstframe, sizeof(firstframe)); /* placeholder for lastframe */
  
  if(X==0)
   buf = (unsigned char*)mmap(0, width*height*2+BTTV_MAX_FBUF, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
  else
   buf = (unsigned char*)mmap(0, BTTV_MAX_FBUF+(Xwidth*Xheight*((XJ_depth+7)/8)), PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
  
  if (buf<=0)
  {
   perror("mmap");
   exit(-1);
  }	

  /* OK Now open all the audio stuff */
  astr=open(a_name, O_RDWR|O_TRUNC|O_CREAT, S_IRUSR|S_IWUSR);
  if(astr<0)
  {
   perror("audioopen");
   exit(-1);
  }
  dsp=open("/dev/dsp", O_RDONLY, 0);		     
  if(dsp<=0)
  {
   perror("dspopen");
   exit(-1);
  }
  f=16;
  if (ioctl(dsp, SNDCTL_DSP_SAMPLESIZE, &f)<0)
  {
   perror("samplesize");
   exit(-1);
  }
  f=0;
  if (ioctl(dsp, SNDCTL_DSP_STEREO, &f)<0)
  {
   perror("stereo");
   exit(-1);
  }
  f=44100;
  ioctl(dsp, SNDCTL_DSP_SPEED, &f);
  printf("Got dsp speed %d\n", f);

  if (ioctl(dsp, SNDCTL_DSP_GETBLKSIZE, &audioblock)<0)
  {
   perror("dsp");
   exit(-1);
  }
  if (audioblock>65536) audioblock=65536;
  if ((audiobuf=(char *)malloc(audioblock))==NULL)
  {
   perror("malloc");
   exit(-1);
  }

/* Now lets setup to capture... */
  fno=0;

  if ((pid_child=fork())==0)
  {
   sigaction(SIGINT, &aqsig, NULL);
   sigaction(SIGALRM, &asig, NULL);
   printf("Waiting for audio sync\n");
   pause();
   printf("Got audio sync\n");
   while(1)
   {
    audiosamp=read(dsp, audiobuf, audioblock);
    if(ioctl(fd, BTTV_FIELDNR, &lastframe)<0) perror("BTTV_FIELDNR");
    write(astr, &audiosamp, sizeof(audiosamp));
    write(astr, &lastframe, sizeof(lastframe));
    write(astr, audiobuf, audiosamp);
   }
  }
  
  sigaction(SIGINT, &vqsig, NULL);

  mm.frame  = 0;
  mm.height = height;
  mm.width  = width;
  mm.format = 0x03; /* RGB 16 */

  if(X==1)
  {
   mm2.frame  = 1;
   mm2.height = Xheight;
   mm2.width  = Xwidth;
   switch (XJ_depth)
   {
    case 8: mm2.format = 0x02; /* RGB 8 */ break;
    case 16: mm2.format = 0x03; /* RGB 16 */ break;
    case 24: mm2.format = 0x04; /* RGB 24 */ break;
    case 32: mm2.format = 0x05; /* RGB 32 */ break;
    
    default: fprintf(stderr, "Unsupported display depth!\n"); break;
   }
  } else
  {
   mm2.frame  = 1;
   mm2.height = height;
   mm2.width  = width;
   mm2.format = 0x03; /* RGB 16 */
  }

  usleep(100000); /* audio should be ready by now! */

  if(starttime!=0)
  {
   printf("\n");
   while(starttime>(ntime=time(NULL)))
   {
    fprintf(stderr, "Current time: %lu Start time: %lu         \r", ntime, starttime);
    sleep(1);
   }
   printf("\n");
  }
  printf("Sending audio sync\n");
  kill(pid_child, SIGALRM);

  if(ioctl(fd, VIDIOCMCAPTURE, &mm)<0) perror("VIDIOCMCAPTURE");
  if(ioctl(fd, VIDIOCMCAPTURE, &mm2)<0) perror("VIDIOCMCAPTURE");
    
  while((endtime==0)|((endtime!=0)&(time(NULL)<endtime)))
  {
   frame=0;
   if(ioctl(fd, VIDIOCSYNC, &frame)<0) perror("VIDIOCSYNC0");
    else
    {
     if(ioctl(fd, BTTV_FIELDNR, &lastframe)<0) perror("BTTV_FIELDNR");
     if(firstframe==0xffffffff)firstframe=lastframe;
     write(ostr[ostrcur], &lastframe, sizeof(lastframe));
     write(ostr[ostrcur++], buf, width*height*2);
     if(ostrcur==ostrnum)ostrcur=0;
     fno++;
    } 
   if(ioctl(fd, VIDIOCMCAPTURE, &mm)<0) perror("VIDIOCMCAPTURE0");
   frame=1;
   if(ioctl(fd, VIDIOCSYNC, &frame)<0) perror("VIDIOCSYNC1");
    else if(X==1)
    {
     for(i=0; i<(Xwidth*Xheight*((XJ_depth+7)/8))/sizeof(unsigned long); i++)
     {
      ((unsigned long *)sbuf)[i]=((unsigned long *)(buf+BTTV_MAX_FBUF))[i];
     }
     XJ_show();
    } else if(half==0)
    {
     if(ioctl(fd, BTTV_FIELDNR, &lastframe)<0) perror("BTTV_FIELDNR");
     write(ostr[ostrcur], &lastframe, sizeof(lastframe));
     write(ostr[ostrcur++], buf+BTTV_MAX_FBUF, width*height*2);
     if(ostrcur==ostrnum)ostrcur=0;
     fno++;
    }
   if(ioctl(fd, VIDIOCMCAPTURE, &mm2)<0) perror("VIDIOCMCAPTURE1");
  }
 videostop(1);
 return 0;
}
