/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

import java.io.DataOutputStream;
import java.io.IOException;

public class BitPacker {
    private int next_bit_to_write = 0;
    private byte[] buffer;

    public BitPacker(int n) {
        this.buffer = new byte[n];
    }

    public int size() {
        return (this.next_bit_to_write + 7) / 8;
    }

    public void getResult(byte[] byArray) {
        System.arraycopy(this.buffer, 0, byArray, 0, (this.next_bit_to_write + 7) / 8);
    }

    public void pack(int n, int n2) {
        while (n2 > 0) {
            int n3 = this.next_bit_to_write / 8;
            int n4 = this.next_bit_to_write % 8;
            int n5 = 1 << n2 - 1;
            byte by = (byte)(1 << 7 - n4);
            if ((n & n5) != 0) {
                int n6 = n3;
                this.buffer[n6] = (byte)(this.buffer[n6] | by);
            }
            ++this.next_bit_to_write;
            --n2;
        }
    }

    public void writeStream(DataOutputStream dataOutputStream) throws IOException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeByte(this.buffer[i]);
        }
    }
}

