/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

public class ColorUtils {
    private static final String INVALID_H_MSG = "Invalid h (it has a value) value when s is zero";

    public static void convertRGBtoHSV(float[] fArray, float[] fArray2) {
        ColorUtils.convertRGBtoHSV(fArray[0], fArray[1], fArray[2], fArray2);
    }

    public static void convertRGBtoHSV(float f, float f2, float f3, float[] fArray) {
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = f > f2 ? f : f2;
        f7 = f7 > f3 ? f7 : f3;
        float f8 = f < f2 ? f : f2;
        f8 = f8 < f3 ? f8 : f3;
        f6 = f7;
        if (f7 == 0.0f) {
            f5 = 0.0f;
            f4 = Float.NaN;
        } else {
            float f9 = f7 - f8;
            f5 = f9 / f7;
            if (f == f7) {
                f4 = (f2 - f3) / f9;
            } else if (f2 == f7) {
                f4 = 2.0f + (f3 - f) / f9;
            } else if (f3 == f7) {
                f4 = 4.0f + (f - f2) / f9;
            }
            f4 *= 60.0f;
            if (f4 < 0.0f) {
                f4 += 360.0f;
            }
        }
        fArray[0] = f4;
        fArray[1] = f5;
        fArray[2] = f6;
    }

    public static void convertHSVtoRGB(float[] fArray, float[] fArray2) {
        ColorUtils.convertHSVtoRGB(fArray[0], fArray[1], fArray[2], fArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void convertHSVtoRGB(float f, float f2, float f3, float[] fArray) {
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f2 == 0.0f) {
            if (!Float.isNaN(f)) throw new IllegalArgumentException(INVALID_H_MSG);
            f4 = f3;
            f5 = f3;
            f6 = f3;
        } else {
            if (f == 360.0f) {
                f = 0.0f;
            }
            int n = (int)Math.floor(f /= 60.0f);
            float f7 = f - (float)n;
            float f8 = f3 * (1.0f - f2);
            float f9 = f3 * (1.0f - f2 * f7);
            float f10 = f3 * (1.0f - f2 * (1.0f - f7));
            switch (n) {
                case 0: {
                    f4 = f3;
                    f5 = f10;
                    f6 = f8;
                    break;
                }
                case 1: {
                    f4 = f9;
                    f5 = f3;
                    f6 = f8;
                    break;
                }
                case 2: {
                    f4 = f8;
                    f5 = f3;
                    f6 = f10;
                    break;
                }
                case 3: {
                    f4 = f8;
                    f5 = f9;
                    f6 = f3;
                    break;
                }
                case 4: {
                    f4 = f10;
                    f5 = f8;
                    f6 = f3;
                    break;
                }
                case 5: {
                    f4 = f3;
                    f5 = f8;
                    f6 = f9;
                }
            }
        }
        fArray[0] = f4;
        fArray[1] = f5;
        fArray[2] = f6;
    }

    public static void convertRGBtoYUV(float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        fArray2[0] = 0.299f * f + 0.587f * f2 + 0.114f * f3;
        fArray2[1] = -0.169f * f - 0.331f * f2 + 0.5f * f3;
        fArray2[2] = 0.5f * f - 0.419f * f2 - 0.081f * f3;
    }

    public static void convertYUVtoRGB(float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        fArray2[0] = f + 1.14f * f3;
        fArray2[1] = f - 0.394f * f2 - 0.581f * f3;
        fArray2[2] = f + 2.028f * f2;
    }

    public static void convertRGBtoYIQ(float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        fArray2[0] = 0.299f * f + 0.587f * f2 + 0.114f * f3;
        fArray2[1] = 0.596f * f - 0.274f * f2 - 0.322f * f3;
        fArray2[2] = 0.212f * f - 0.523f * f2 - 0.311f * f3;
    }

    public static void convertYIQtoRGB(float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        fArray2[0] = f + 0.956f * f2 + 0.621f * f3;
        fArray2[1] = f - 0.272f * f2 - 0.647f * f3;
        fArray2[2] = f - 1.105f * f2 + 1.702f * f3;
    }
}

