#ifndef FRAMEOBJ_H
#define FRAMEOBJ_H

#include "mapobj.h"

enum FrameType {NoFrame,Rectangle};

class FrameObj:public MapObj {
public:
    FrameObj();
    FrameObj(QCanvas*);
    ~FrameObj();
    void init();
    void clear();
    void move (double x,double y);    // move to absolute Position
    void moveBy (double x,double y);  // move to relative Position
	void positionBBox();			 
	void calcBBoxSize();			
	void setRect (const QRect &);	  // set dimensions			
    int getBorder();
    FrameType getFrameType ();
    QString getFrameTypeName ();
    void setFrameType (const FrameType &);
    void setFrameType (const QString &);
    void setVisibility(bool);

protected:
    FrameType type;
    QCanvasRectangle* rectFrame;
    int border;									// distance text - frame
};
#endif

