/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "UploadDelegate.h"
#import "waiho.h"

@implementation UploadTableView
- (int) numberOfRowsInTableView: (NSTableView *)aTableView {
	int ret = 0;
	NSArray* uploadQueue = nil;

	NSLog (@"uploadtableview numberofrowsintableview");
	uploadQueue = [(MyDelegate*)[NSApp delegate] uploadQueue];
	if (uploadQueue != nil)
	{
		ret = [uploadQueue count];
	}
    	NSLog (@"upload numberOfRowsInTableView : %i", ret);
	return ret;
}
- (id)  tableView: (NSTableView *)aTableView objectValueForTableColumn: (NSTableColumn *) aTableColumn row:(int)rowIndex {
	NSArray* uploadQueue = [[NSApp delegate] uploadQueue];
	File* f;

	if (uploadQueue != nil)
	{
		f = [uploadQueue objectAtIndex: rowIndex];

		if ([[aTableColumn identifier] isEqual: @"Name"])
		{
			return [f name];
		}
		if ([[aTableColumn identifier] isEqual: @"Size"])
		{
			return [f printsize];
		}
		if ([[aTableColumn identifier] isEqual: @"Status"])
		{
			return [f getStatus];
		}
	}
	return nil;
}

@end
