// Copyright (c) The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
//
// $Id: ControlManager.cpp
//
//---------------------------------------------------------------------------

#include "ControlManager.h"
#include "TimeWarpSimulationManager.h"
#include "SimulationConfiguration.h"
#include "CommunicationManager.h"
#include <clutils/ConfigurationChoice.h>
#include <clutils/StringUtilities.h>
#include <fstream>
using std::ofstream;
using std::cout;
using std::cerr;
using std::endl;

ControlManager::ControlManager(TimeWarpSimulationManager *simMgr):mySimulationManager(simMgr){}

ControlManager::~ControlManager(){
//   const vector<Sensor *> *sensors = sensorDataBase.toVector();
  
//   const vector<Sensor *>::const_iterator iter_begin = sensors->begin();
//   const vector<Sensor *>::const_iterator iter_end   = sensors->end();
  
//   *infoStream << "------------------" << endl;
//   *infoStream << "Sensor-Value Pairs" << endl;
//   *infoStream << "------------------" << endl;
  
//   vector<Sensor *>::iterator current = iter_begin;
//   while( current != iter_end ){
//     (*current)->dump(*infoStream);
//     ++current;
//   }
}

void
ControlManager::configure( SimulationConfiguration & ){
  abort();

//   const ConfigurationChoice *choice = configuration.findChoice("CONTROLMANAGEROUTPUT");
//   if( choice != 0 ){
//     if( choice->getStringValue() == "YES" ){
//       string output;
//       output = "controlManager_" 
// 	+ intToString( mySimulationManager->getSimulationManagerID() )
// 	+ ".dat";
//       infoStream = new ofstream( output.c_str() );
//     }
//     else {
//       infoStream = &cout;
//     }
//   }
//   registerWithCommunicationManager();
}

void
ControlManager::registerSensor(string &name, Sensor* sensor){
   if( sensorDataBase.find(name) != sensor){
     sensorDataBase.insert(name, sensor );
   }
   else {
      cerr << "Sensor " << name << " already exists !!" << endl;
      cerr << "ControlManager Error: aborting simulation" << endl;
      abort();
   }
}

void
ControlManager::registerActuator(string &name, Actuator* actuator){
   if(actuatorDataBase.find( name ) != actuator){
     actuatorDataBase.insert( name, actuator );
   }
   else {
      cerr << "Actuator " << name << " already exists !!" << endl;
      cerr << "ControlManager Error: aborting simulation" << endl;
      abort();
   }
}

// the ControlManager must register the following message types with
// the communication manager: ControlStatusMessage, InitiateAdjustmentMessage 
void
ControlManager::registerWithCommunicationManager(){
  const int numberOfMessageTypes = 2;
  string messageType[numberOfMessageTypes] = { "ControlStatusMessage",
					       "InitiateAdjustmentMessage" };
  ASSERT(mySimulationManager != NULL);
  for(int count = 0; count < numberOfMessageTypes; count++){
    mySimulationManager->getCommunicationManager()->registerMessageType(messageType[count], this);
  }
}

// the communication manager will call this method to deliver a
// ControlStatusMessage or a InitiateAdjustmentMessage.
void
ControlManager::receiveKernelMessage(KernelMessage *){}

void
ControlManager::initiateParameterAdjustment(){}

void
ControlManager::initiateControlAction(){}

