#include "StartMessage.h"
#include "DeserializerManager.h"

void 
StartMessage::serialize( SerializedInstance *addTo ) const {
  return KernelMessage::serialize( addTo );
}

Serializable *
StartMessage::deserialize( SerializedInstance *data ){
  unsigned int source = data->getUnsigned();
  unsigned int dest = data->getUnsigned();
  return new StartMessage( source, dest );
}

const string &
StartMessage::getStartMessageType(){
  static const string startMessageType = "StartMessage";
  return startMessageType;
}


void 
StartMessage::registerDeserializer(){
  DeserializerManager::instance()->registerDeserializer( getStartMessageType(),
							 &deserialize );
}
