#ifndef UDP_SELECT_PHYSICAL_COMMUNICATION_LAYER_H
#define UDP_SELECT_PHYSICAL_COMMUNICATION_LAYER_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Jorgen Dahl                 dahlj@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu


//#include "warped.h"
#include "eclmplSocket.h"
#include "eclmplCommonInclude.h"
#include "eclmplUnreliableNetworkMessage.h"
#include "eclmplReliablePhysicalCommunicationLayer.h"
#include "eclmplTimer.h"
#include "UDPConnectionInterface.h"

/** The UDPSelectPhysicalCommunicationLayer class.

*/
class UDPSelectPhysicalCommunicationLayer : public eclmplReliablePhysicalCommunicationLayer {
public:
  /**@name Public Class Methods of UDPSelectPhysicalCommunicationLayer. */
  //@{

  /// Default Constructor.
  UDPSelectPhysicalCommunicationLayer();

  /// Destructor.
  ~UDPSelectPhysicalCommunicationLayer();
  
  //@} // End of Public Class Methods of UDPSelectPhysicalCommunicationLayer.

protected:
  /**@name Protected Class Methods of UDPSelectPhysicalCommunicationLayer. */
  //@{
  void probeNetwork();
  void initializeCommunicationLayerAttributes();

  //bool UDP_SynchronizeMaster(const eclmplUnreliableNetworkMessageType &msgType);
  //bool UDP_SynchronizeSlave(const eclmplUnreliableNetworkMessageType &msgType);
  //void UDP_Finalize();

  //@} // End of Protected Class Attributes of UDPSelectPhysicalCommunicationLayer.

  /**@name Protected Class Attributes of UDPSelectPhysicalCommunicationLayer. */
  //@{

  // UDP_SELECT:
  fd_set selectListenSet, fdSet;
  int maxFd;

  //@} // End of Protected Class Attributes of UDPSelectPhysicalCommunicationLayer.
};

#endif
