/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "command.h"

using namespace WebIssues;

Command::Command() :
    m_acceptBinaryResponse( false ),
    m_acceptNullReply( false )
{
}

Command::~Command()
{
}

void Command::addArg( int number )
{
    m_args.append( QVariant( number ) );
}

void Command::addArg( const QString& string )
{
    m_args.append( QVariant( string ) );
}

void Command::addRule( const QString& signature, ReplyRule::Multiplicity multiplicity )
{
    m_rules.append( ReplyRule( signature, multiplicity ) );
}

void Command::setSendProgress( int done, int total )
{
    emit sendProgress( done, total );
}

void Command::setReadProgress( int done, int total )
{
    emit readProgress( done, total );
}

void Command::setCommandReply( const Reply& reply )
{
    emit commandReply( reply );
}

void Command::setBinaryBlock( const char* data, int length )
{
    emit binaryBlock( data, length );
}
