#!/usr/local/bin/perl
# save_soa.cgi
# Save changes to an SOA record

require './bind8-lib.pl';
&ReadParse();
&error_setup($text{'master_err2'});
%access = &get_module_acl();
$conf = &get_config();
if ($in{'view'}) {
        $view = $conf->[$in{'view'}];
        $conf = $view->{'members'};
        }
$zone = $conf->[$in{'index'}];
&can_edit_zone(\%access, $zone, $view) ||
	&error($text{'master_ecannot'});
$access{'ro'} && &error($text{'master_ero'});
$access{'params'} || &error($text{'master_esoacannot'});

# check inputs
&valdnsname($in{'master'}, 0, $in{'origin'}) ||
	&error(&text('master_emaster', $in{'master'}));
&valemail($in{'email'}) ||
	&error(&text('master_eemail', $in{'email'}));
$in{'refresh'} =~ /^\d+$/ ||
	&error(&text('master_erefresh', $in{'refresh'}));
$in{'retry'} =~ /^\d+$/ ||
	&error(&text('master_eretry', $in{'retry'}));
$in{'expiry'} =~ /^\d+$/ ||
	&error(&text('master_eexpiry', $in{'expiry'}));
$in{'minimum'} =~ /^\d+$/ ||
	&error(&text('master_eminimum', $in{'minimum'}));
if ($in{'email'} =~ /\@/) {
	$in{'email'} = &email_to_dotted($in{'email'});
	}
$in{'defttl_def'} || $in{'defttl'} =~ /^\d+$/ ||
	&error(&text('master_edefttl', $in{'defttl'}));

&lock_file(&make_chroot($in{'file'}));
@recs = &read_zone_file($in{'file'}, $in{'origin'});
$old = $recs[$in{'num'}];
# already set serial if no acl allow it to update or update is disabled
$serial = $old->{'values'}->[2];
if ($config{'updserial_on'}) { # generally handle serial numbers ?
	if ($config{'soa_style'} == 1 && $old->{'values'}->[2] =~ /^(\d{8})(\d\d)$/) {
        	if ($1 eq &date_serial()) { $serial = sprintf "%d%2.2d", $1, $2+1; }
        	else { $serial = &date_serial()."00"; }
        	}
	else {
        	$serial = $old->{'values'}->[2]+1;
        	}
	}
else {
	$in{'serial'} =~ /^\d+$/ || &error($text{'master_eserial'});
	$serial = $in{'serial'};
	}
$vals = "$in{'master'} $in{'email'} (\n".
	"\t\t\t$serial\n".
	"\t\t\t$in{'refresh'}$in{'refunit'}\n".
	"\t\t\t$in{'retry'}$in{'retunit'}\n".
	"\t\t\t$in{'expiry'}$in{'expunit'}\n".
	"\t\t\t$in{'minimum'}$in{'minunit'} )";
&modify_record($in{'file'}, $old, $old->{'name'}, $old->{'ttl'},
	       $old->{'class'}, "SOA", $vals);

($defttl) = grep { $_->{'defttl'} } @recs;
if (!$defttl && !$in{'defttl_def'}) {
	&create_defttl($in{'file'}, $in{'defttl'}.$in{'defttlunit'});
	}
elsif ($defttl && !$in{'defttl_def'}) {
	&modify_defttl($in{'file'}, $defttl, $in{'defttl'}.$in{'defttlunit'});
	}
elsif ($defttl && $in{'defttl_def'}) {
	&delete_defttl($in{'file'}, $defttl);
	}

&unlock_file(&make_chroot($in{'file'}));
&webmin_log("soa", undef, $in{'origin'}, \%in);
&redirect("edit_master.cgi?index=$in{'index'}&view=$in{'view'}");

