#!/usr/bin/perl
#
# Snort Webmin Module
# 
# Copyright (C) 2001 Mike Baptiste/MSB Networks
#                    mike@msbnetworks.com
#                    http://msbnetworks.com/snort/
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# Do common initialization and get common routines
# Note this also does the acl acess lookup
require 'snort-lib.pl';

# Lets check and make sure the module was configured with defaults during installation,
# or that settings have been previously saved, otherwise, lets dump them to the config screen
($snort_bin) = $config{'snort_path'} =~ /^(\S+)/;  # Strip any options - note this will choke if there are spaces in path!
if ((! -r $snort_bin) || (! -r $config{'snort_config'}) || (! -d $config{'snort_rules_path'})) {
   # Check if they can change config first!
   if ($access{'noconfig'}) {
      $whatfailed = $text{'error_confchk'};
      &snort_error($text{'error_config'});
   } else {
      &redirect("/config.cgi?snort");  # Redirect user to config section
      exit;
   }
}

# Send the header
&header($text{'index_title'}, "", undef, 1, 1, 0,
   &help_search_link("snort", "man", "doc", "google"));
print "<hr>\n";

# Display icons for global options if user can modify them
if ($access{'net'} || $access{'pp'} || $access{'out'} || $access{'text'}) {
   print "<h3>$text{'index_opts'}</h3>\n";
   push(@olinks, "conf_net.cgi") if $access{'net'};
   push(@olinks, "conf_preproc.cgi") if $access{'pp'};
   push(@olinks, "conf_output.cgi") if $access{'out'};
   push(@olinks, "conf_text.cgi") if $access{'text'};
   @otitles = map { /conf_(\S+).cgi/; $text{$1."_title"} } @olinks;
   @oicons = map { /^conf_(\S+).cgi/; "images/$1.gif"; } @olinks;
   # Lets toss in an ACID link if they use it
   if ($config{'acid_url'}) {
      push(@olinks, $config{'acid_url'});
      push(@otitles, "Goto ACID");
      push(@oicons, "images/acid.png");
   }
   &icons_table(\@olinks, \@otitles, \@oicons);
   print "<hr>\n";
}

# Scan the configuration file for rule sets
$sconf = read_file_lines($config{'snort_config'});
@rulefiles = grep(/\w+\.rules/, @$sconf);

# Display rules if they can modify them
print "<p><center><font size=+1><b>$text{'index_rules'}</b></font>\n";
print "<br><font size=-1><img src=\"images/enabled.gif\" alt=\"$text{'index_enabled'}\"> = $text{'index_enabled'}&nbsp;&nbsp;<img src=\"images/disabled.gif\" alt=\"$text{'index_disabled'}\"> = $text{'index_disabled'}</font>\n";
print "<br><font size=-1>$text{'index_rule_msg'}</font>" if ($access{'rules'} ne "*");

foreach $ruleset (@rulefiles) {
   ($rule) = $ruleset =~ /[#]*(\S+)\.rules/;

   # Check to see if user can access a given ruleset
   if ($access{'rules'} ne "*") {
      if ($access{'rules'} =~ /^\!/) {
         # The access array is all EXCEPT selected
         next if ($access{'rules'} =~ /\b$rule\b/);
      } else {
         next if ($access{'rules'} !~ /\b$rule\b/);
      } 
   }

   # If the ruleset is commented out - its disabled
   if ($access{'ruleview'} || $access{'ruleedit'} || $access{'ruleadd'} || $access{'ruledel'}) {
      $rulerow{$rule} = "<td><a href=\"conf_rules.cgi?rule=$rule\">$rule</a></td><td align=center>";
   } else {
      $rulerow{$rule} = "<td>$rule</td><td align=center>";
   }

   if ($ruleset =~ /^#/) {
      # The ruleset is disabled
      $rulerow{$rule} .= "<img src=\"images/disabled.gif\" alt=\"$text{'index_disabled'}\"></td>";
      $rulerow{$rule} .= "<td><a href=\"rule_status.cgi?rule=$rule\">$text{'index_enable'}" if $access{'ruletog'};
   } else {
      $rulerow{$rule} .= "<img src=\"images/enabled.gif\" alt=\"$text{'index_enabled'}\"></td>";
      $rulerow{$rule} .= "<td><a href=\"rule_status.cgi?rule=$rule\">$text{'index_disable'}" if $access{'ruletog'};
   }
}

# Now we output the rules in the columns
#
# NOTE - There may be a MUCH more elegant way of doing this.  I spent WAY too much time
# thinking about this and trying to get this table pretty and printing properly across
# three columns.  If you have ideas for improvement, pass them on!
#
# The trick is keeping the list in alphabetical order reading down one column at a time
# Make sure that the code can handle < 3 rulesets
@ruleidx = sort keys %rulerow;
$numitems = @ruleidx;
if ($numitems > 0) {
   if ($numitems >= 3) { $numcols = 3 } else { $numcols = $numitems }
   $limit = int($numitems/$numcols);
   $extra = $numitems - ($numcols * $limit);  # How many items will be in bottom row

   # Lets display the rulesets in 3 columns of 3 columns each
   # We need to make sure we only display headers if we have enough rules to display

   print "<p><table border=0 cellspacing=1><tr $tb>\n";
   for ($i=1; $i <= $numcols; $i++) {
      print "<th>$text{'index_rule_hdr1'}</th><th>$text{'index_rule_hdr2'}</th>";
      print "<th>$text{'index_rule_hdr3'}</th>" if $access{'ruletog'};
      print "<td $tb width=5>&nbsp;</td>\n" if ($i < $numcols);
   }
   print "</tr>\n";

   # Now lets output the data
   for ($i=0; $i <= $limit; $i++) {
      next if ((!$extra) && ($i == $limit));  # Skip bottom extra row if necessary
      print "<tr $cb>";
      # For the last row, we do something special
      $offset = 0;
      for ($j=$i; $j < $numitems; $j+=$limit) {
         # On the last row ($i = $limit) only loop $extra times
         next if (($extra <= $offset) &&  ($i == $limit));
         print "<td $tb width=5>&nbsp;</td>" if $offset;
         print $rulerow{$ruleidx[$j]};
         $j++ if ($extra > $offset++);  # Tweak index value in non perfect tables
      }
      print "</tr>\n";
   }
   print "</table>\n";
} # if ($numitems > 0)
print "</center>\n<hr>\n";

# Lets see if snort is already running or not
if ($access{'apply'}) {
   if (open(PID, $config{'snort_pid'})) {
      chop($pid = <PID>);
      close(PID);
   }

   print "<form method=post action=\"snort_ctl.cgi\">\n";

   if ($pid && kill(0, $pid)) {
      print "<b>$text{'index_apply_info'}</b><p>\n";
      print "<input type=hidden name=pid value=$pid>\n";
      print "<input type=submit name=submit value=\"$text{'index_restart'}\">\n";
      print "<input type=submit name=submit value=\"$text{'index_stop'}\">\n";
   } else {
      # Unable to find PID - show start button
      print "<b>$text{'index_start_hdr'}</b><br>\n";
      print "<font size=-1>$text{'index_start_info'}</font>\n<p>\n";
      print "<input type=submit name=submit value=\"$text{'index_start'}\">\n";
   }

   # Check if Snort is running and allow user to (re)start it if allowed

   print "</form>\n";
   print "<hr>\n";

} # if ($access{'apply'})

# we're done here, just print the footer and quit
&footer("/", $text{"index"});
exit;

