#!/usr/bin/perl
# snort_ctl.cgi
#
# Used to start, stop, and restart the snort process

require './snort-lib.pl';
&ReadParse();

$access{'apply'} || &snort_error($text{'ctl_noacc'});

# We have 3 funcitons here, start, stop, and restart
if ($in{'submit'} eq $text{'index_restart'}) {
   # Lets restart the process with a HUP
   &kill_logged('TERM', $in{'pid'}) ||
      &snort_error(&text('ctl_restart_err', $in{'pid'}, "<p><tt>" . &html_escape($!) . "</tt>"));
   &webmin_log("restart");

   $in{'submit'} = $text{'index_start'};  # Fake out start code to execute after stop for restart
}

# We split the if here since we need to start for a restart which is actually a stop/start
if ($in{'submit'} eq $text{'index_start'}) {
   # Lets start the process - we have a couple choices to do so
   if ($config{'snort_rc'}) {
      $cmd = $config{'snort_rc'};
   } elsif ($config{'snort_path'}) {
      $cmd = $config{'snort_path'};
   } else {
      # Whoops - no command is available :(
      &snort_error($text{'ctl_start_nocmd'});
   }

   # Lets start and see what we get back
   $temp = &tempname();
   $rv = &system_logged("$cmd </dev/null >$temp 2>&1");
   $out = `cat $temp`;
   unlink($temp);

   # If we got anything back, well thats not a good thing
   if ($rv || $out =~ /err/) {
      &snort_error(&text('ctl_start_err', "<p><tt>" . &html_escape($out) . "</tt>", "<tt>" . &html_escape($rv) . "</tt>"));
   }

   # Cool - started OK - lets log it
   &webmin_log("start");
} elsif ($in{'submit'} eq $text{'index_stop'}) {
   # Lets stop the process
   &kill_logged('TERM', $in{'pid'}) ||
      &snort_error(&text('ctl_stop_err', $in{'pid'}, "<p><tt>" . &html_escape($!) . "</tt>"));
   &webmin_log("stop");
}

# We're done here - lets jump back home
&redirect("");

exit;
