#!/usr/local/bin/perl
# bwgraph.cgi
# Show current bandwidth usage graphs

require './virtual-server-lib.pl';
&ui_print_header(undef, $text{'bwgraph_title'}, "");
&ReadParse();

# Work out which domains to show
if ($in{'dom'}) {
	@doms = ( &get_domain($in{'dom'}) );
	}
else {
	@doms = grep { !$_->{'parent'} } &list_domains();
	}
foreach $d (@doms) {
	&can_edit_domain($d) || &error($text{'newbw_ecannot'});
	}

# Show current usage and limit for all virtual servers
$max = 0;
foreach $d (@doms) {
	$max = $d->{'bw_usage'} if ($d->{'bw_usage'} > $max);
	$max = $d->{'bw_limit'} if ($d->{'bw_limit'} > $max);
	}
if ($max) {
	# Show links for mode
	print "<b>$text{'bwgraph_mode'}</b>\n";
	foreach $m (0, 1) {
		$t = $text{'bwgraph_mode_'.$m};
		if ($m == $in{'mode'}) {
			print $t;
			}
		else {
			print "<a href='bwgraph.cgi?mode=$m&dom=$in{'dom'}'>$t</a>\n";
			}
		print "&nbsp;|&nbsp;\n" if ($m == 0);
		}
	print "<p>\n";

	# Show table
	$width = 500;
	print "<table>\n";
	print "<tr> <td><b>$text{'newbw_dom'}</b></td>\n";
	print "<td><b>",&text('edit_bwpast_'.$config{'bw_past'},
			      $text{'newbw_graph'}, $config{'bw_period'}),
	      "</b></td>\n";
	print "<td><b>$text{'newbw_glimit'}</b></td>\n";
	print "<td><b>$text{'newbw_gusage'}</b></td>\n";
	print "</tr>\n";
	foreach $d (sort { $b->{'bw_usage'} <=> $a->{'bw_usage'} }
		    grep { !$_->{'parent'} }
		    @doms) {
		$usage = $in{'mode'} == 1 ? $d->{'bw_usage_only'}
					  : $d->{'bw_usage'};
		print "<tr> <td><a href='edit_domain.cgi?dom=$d->{'id'}'>",
		      "$d->{'dom'}</td> <td nowrap>\n";
		if ($d->{'bw_limit'}) {
			printf "<img src=images/red.gif width=%s height=10>\n",
				int($width*$d->{'bw_limit'}/$max)+1;
			}
		else {
			printf "<img src=images/grey.gif width=%s height=10>\n",
				$width;
			}
		printf "<br><img src=images/blue.gif width=%s height=10>\n",
			int($width*$usage/$max)+1;
		print "</td>\n";
		print "<td>\n";
		if ($d->{'bw_limit'}) {
			print &nice_size($d->{'bw_limit'});
			}
		else {
			print $text{'newbw_unlim'};
			}
		print "</td>\n";
		print "<td>",&nice_size($usage),"</td>\n";
		print "</tr>\n";

		next if ($in{'mode'} != 1);

		# Show sub-servers
		$space = $d->{'bw_usage_only'};
		foreach $sd (&get_domain_by("parent", $d->{'id'})) {
			print "<tr> <td>&nbsp;&nbsp;&nbsp;",
			      "<a href='edit_domain.cgi?dom=$sd->{'id'}'>",
			      "$sd->{'dom'}</td> <td>\n";
			printf "<img src=images/white.gif width=%s height=10>",
				int($width*$space/$max);
			printf "<img src=images/blue.gif width=%s height=10>",
				int($width*$sd->{'bw_usage_only'}/$max);
			print "</td>\n";
			print "<td></td>\n";
			print "<td>",&nice_size($sd->{'bw_usage_only'}),"</td>\n";
			print "</tr>\n";
			$space += $sd->{'bw_usage_only'};
			}
		}
	print "</table>\n";
	}
else {
	print "<b>$text{'bwgraph_none'}</b><p>\n";
	}

&ui_print_footer("", $text{'index_return'});

