#!/usr/local/bin/perl
# Generate a CSR and private key for this domain

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});
&foreign_require("webmin", "webmin-lib.pl");

# Validate inputs
&error_setup($text{'csr_err'});
$in{'commonName'} =~ /^[A-Za-z0-9\.\-]+$/ ||
	&error($webmin::text{'newkey_ecn'});
$in{'size_def'} || $in{'size'} =~ /^\d+$/ ||
	&error($webmin::text{'newkey_esize'});
$in{'days'} =~ /^\d+$/ || &error($webmin::text{'newkey_edays'});

# Generate the private key
$d->{'ssl_csr'} ||= "$d->{'home'}/ssl.csr";
$d->{'ssl_newkey'} ||= "$d->{'home'}/ssl.newkey";
unlink($d->{'ssl_newkey'});
$out = &backquote_logged("openssl genrsa -out ".quotemeta($d->{'ssl_newkey'})." $size 2>&1 </dev/null");
chown($d->{'uid'}, $d->{'ugid'}, $d->{'ssl_newkey'});
chmod(0755, $d->{'ssl_newkey'});
if (!-r $d->{'ssl_newkey'} || $?) {
	&error(&text('csr_ekey', "<pre>$out</pre>"));
	}

# Generate the CSR
$outtemp = &tempname();
unlink($d->{'ssl_csr'});
open(CA, "| openssl req -new -key ".quotemeta($d->{'ssl_newkey'})." -out ".
	 quotemeta($d->{'ssl_csr'})." >$outtemp 2>&1");
print CA ($in{'countryName'} || "."),"\n";
print CA ($in{'stateOrProvinceName'} || "."),"\n";
print CA ".\n";
print CA ($in{'organizationName'} || "."),"\n";
print CA ($in{'organizationalUnitName'} || "."),"\n";
print CA ($in{'commonName_def'} ? "*" : $in{'commonName'}),"\n";
print CA ($in{'emailAddress'} || "."),"\n";
print CA ".\n";
print CA ".\n";
close(CA);
$rv = $?;
$out = `cat $outtemp`;
unlink($outtemp);
chown($d->{'uid'}, $d->{'ugid'}, $d->{'ssl_csr'});
chmod(0755, $d->{'ssl_csr'});
if (!-r $d->{'ssl_csr'} || $?) {
	&error(&text('csr_ecsr', "<pre>$out</pre>"));
	}

# Save the domain
&save_domain($d);
&run_post_actions();

# Show the output
&ui_print_header(&domain_in($d), $text{'csr_title'}, "");

print "$text{'csr_done'}<p>\n";

print &text('csr_csr', "<tt>$d->{'ssl_csr'}</tt>"),"\n";
print "<pre>",`cat $d->{'ssl_csr'}`,"</pre>\n";

print &text('csr_key', "<tt>$d->{'ssl_newkey'}</tt>"),"\n";
print "<pre>",`cat $d->{'ssl_newkey'}`,"</pre>\n";

&ui_print_footer("cert_form.cgi?dom=$in{'dom'}", $text{'cert_return'},
	"edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
	"", $text{'index_return'});
