/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h> // for printf // remove this RV@@6

#include "realtime.h"
#include "defs.h"

#ifdef ENABLE_NFULOG
extern "C" {
#include <libipulog.h>
}

#define MYBUFSIZ 2048

extern int wflogs_realtime_fd;

// we shouldn't have to do this... ulog should export it, or at least fd RV@@9
struct ipulog_handle {
  int fd;
  u_int8_t blocking;
  struct sockaddr_nl local;
  struct sockaddr_nl peer;
  struct nlmsghdr* last_nlhdr;
};

// make this a private member of the class RV@@9
static struct ipulog_handle* h;

void
wf_inmodule_netfilter_realtime_init() {
  /* create ipulog handle */
  //  h = ipulog_create_handle(ipulog_group2gmask(atoi(argv[2])), MYBUFSIZ);
  //  h = ipulog_create_handle(ipulog_group2gmask(1)); // RV@@9 not 1
  h = ipulog_create_handle(-1U, MYBUFSIZ); /* every group */
  if (h == NULL) {
    ipulog_perror(NULL); /* if some error occurs, print it to stderr */
    exit(1); // RV@@9 really exit here?
  }
  wflogs_realtime_fd = h->fd;
}

void
wf_inmodule_netfilter_realtime_fini() {
  ipulog_destroy_handle(h);
}

/* prints some logging about a single packet */
// remove this function RV@@9
void handle_packet(ulog_packet_msg_t *pkt)
{
	unsigned char *p;
	int i;
	
	printf("Hook=%u Mark=%lu len=%d ",
	       pkt->hook, pkt->mark, pkt->data_len);
	if (strlen(pkt->prefix))
		printf("Prefix=%s ", pkt->prefix);
	
	if (pkt->mac_len)
	{
		printf("mac=");
		p = pkt->mac;
		for (i = 0; i < pkt->mac_len; i++, p++)
			printf("%02x%c", *p, i==pkt->mac_len-1 ? ' ':':');
	}
	printf("\n");

}
#endif /* ENABLE_NFULOG */


void
wf_inmodule_netfilter_realtime_read() {
#ifdef ENABLE_NFULOG
  unsigned char* buf = (unsigned char*)malloc(MYBUFSIZ);  /* allocate a receive buffer */
  int len = ipulog_read(h, buf, MYBUFSIZ, 1);
  if (len <= 0) {
    ipulog_perror("ulog_test: short read"); // better error message RV@@9
    exit(1); // RV@@9 really exit here?
  }
  printf("%d bytes received\n", len);
  ulog_packet_msg_t *upkt;
  while ((upkt = ipulog_get_packet(h, buf, len))) {
    handle_packet(upkt);
  }
#endif /* ENABLE_NFULOG */
}
