/*
  libu - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 2002 Malcolm Walker
  Based on code copyright  (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
#include "multilineedit.h"
#include "pushbutton.h"
#include "rootwindow.h"
#include "sample.h"
#include "mixer.h"
#include "box.h"
#include "filler.h"
#include "table.h"
#include "label.h"

#include "quitcheck.h"

using namespace wftk;

#include <iostream>

static Widget*
imageWidget(const std::string& image)
{
  Surface *surf = new Surface();
  surf->readFromFile(image);
  surf->setColorKey("black");
  Surface::Resource *res = new Surface::Resource(surf);
  Widget* widget = new Widget(res, false);
  res->free();

  return widget;
}

class AlphaApp : public QuitCheckApp
{
 public:
  AlphaApp(int argc, char** argv) :
    QuitCheckApp(argc, argv)
    {
      std::cout << "starting up ..." << std::endl;
      //do you init here

      RootWindow* back = new RootWindow(640,480);
  
      back->setTitle("LIBWFTK Demo");

      //eg fontloading ....
      // These fonts are used by several gui elements from libwftk,
      // so you should slways load text_font and button_font when
      // using widgets from libwftk.
      Font::registry.load("text_font","wf_opal.ttf, 16, 0xF0F0F0, 0x80101010");
      Font::registry.load("button_font","wf_opal.ttf, 18, 0xF0F0F0, 0x80101010");

      if(Mixer::instance()->audioAvailable()) {
        // register this wav file as the "press" resource
        // it is played whenever an button gets pressed
        Sample::registry.load("press","press.wav");
        // same, but for "release" (button release)
        Sample::registry.load("release","release.wav");
      }
      
      Surface::registry.load("background","background.png");

      back->setBackground("background");

      Box *main_box = new Box(Box::LEFT_TO_RIGHT);
      back->pack(main_box);

      Box *left_box = new Box(Box::TOP_TO_BOTTOM);
      main_box->packBack(left_box);

      // GUI creation code
      MultiLineEdit* info 
	= new MultiLineEdit("LIBWFTK - AlphaTest\n"
			    "written by Karsten Laux",
			    Font::registry.find("button_font"));
      info->setColor(Color(0,48,128,128));
      left_box->packBack(info);


      left_box->packBack(new Filler(Filler::VERTICAL));

      Box *right_box = new Box(Box::TOP_TO_BOTTOM);
      main_box->packBack(right_box);

      Box *logo_box = new Box(Box::LEFT_TO_RIGHT);
      right_box->packBack(logo_box);

      logo_box->packBack(new Filler(Filler::HORIZONTAL));

      logo_box->packBack(new Widget("wftk_logo"));

      right_box->packBack(new Filler(Filler::VERTICAL));

      //a pushbutton
      PushButton* quit_button = new PushButton("Quit");
      right_box->packBack(quit_button);

      //connect this button's click event (SIGNAL) with the application's
      //quit action (SLOT)
      quit_button->clicked.connect(quitSlot());

      Table *table = new Table;
      left_box->packBack(table);

      table->pack(new Filler(Filler::HORIZONTAL), 0, 0, 1, 5);
      table->pack(new Filler(Filler::HORIZONTAL), 2, 0, 1, 2);
      table->pack(new Filler(Filler::HORIZONTAL), 2, 3, 1, 2);
      table->pack(new Filler(Filler::HORIZONTAL), 4, 0, 1, 5);

      table->pack(new Filler(Filler::VERTICAL), 1, 2, 3, 1);

      table->pack(imageWidget("image8.png"), 1, 0);
      table->pack(new Label("indexed"), 1, 1);

      table->pack(imageWidget("image32.png"), 3, 0);
      table->pack(new Label("RGB, alpha"), 3, 1);

      table->pack(imageWidget("image_gray.png"), 1, 3);
      table->pack(new Label("greyscale"), 1, 4);

      table->pack(imageWidget("image_gray_alpha.png"), 3, 3);
      table->pack(new Label("greyscale, alpha"), 3, 4);

      left_box->packBack(new Filler(Filler::VERTICAL));
    }
};


  
int main (int argc, char **argv)
{
  return AlphaApp(argc, argv).exec();
}

