/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _FULL_SCREEN_DIALOG_H
#define _FULL_SCREEN_DIALOG_H

#include <wftk/dialog.h>
#include <sigc++/connection.h>

namespace wftk {

/** 
 * A dialog that completely fills its parent widget.
 */
class FullScreenDialog : public Dialog
{
 public:
  /**
   * Constructor
   */
  explicit FullScreenDialog() : parent_(0) {}

 protected:
   /**
   * resize Dialog
   *
   * since Dialog is essentially the root of its own packing
   * structure (i.e., a dialog's size doesn't affect how RootWindow's
   * other children are packed), resize Dialog based on the
   * new packing info.
   */
  virtual void packingUpdateParent();
 private:
  ///
  void parentResized(Uint16 w, Uint16 h) {packingUpdateParent();}
  ///
  SigC::Connection parent_resize_;
  ///
  ScreenArea* parent_;
};

} // namespace wftk

#endif // !_DIALOG
