/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux 

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _LABEL_H
#define _LABEL_H

#include <wftk/widget.h>
#include <wftk/font.h>

namespace wftk {

/// Display a text message onscreen
class Label : public Widget
{
 //OBJECT

 public:
  /// Enumeration for horizontal text alignment
  enum align_t {ALIGN_LEFT, ALIGN_RIGHT, ALIGN_CENTER};
  /// Construct this label with the given text, drawn with the given Font
  explicit Label(const std::string& text = "", const Font &font=Font());
  ///
  virtual ~Label();  
  /// Set the text color (foreground only)
  void setTextColor(const Color& fontCol);
  /// Set the horizontal (left, center, right) alignment of this Label
  void setAlign(align_t align) {align_ = align; invalidate();}

  /// Set the text for this Label
  void setText(const std::string&);
  /// Return the text of this Label
  const std::string& getText() const {return labelText_;}

 protected:
  ///
  virtual void draw(Surface&, const Point&, const Region&);
  ///
  virtual void setPackingInfo();
 private:
  ///
  std::string labelText_;
  ///
  Surface* text_;
  ///
  Font labelFont_;
  ///
  align_t align_;
};

} // namepspace wftk

#endif // _LABEL_H
