/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _MESSAGEBOX_H
#define _MESSAGEBOX_H

#include <wftk/bordereddialog.h>

namespace wftk {

/** 
 *Display a message to the user, allow them to dismiss this box
 */
class MessageDialog : public BorderedDialog
{
 
 public:
  /**
   * Create a message box
   *\param title the title of the message box
   *\param msg message to display in the box
   *\param border_res_name std::string containing the name of the ressource
   *                       to use for the frame. The ressources are 
   *                       \li &lt;name&gt;_v for the vertical frames
   *                       \li &lt;name&gt;_h for the horizontal frames
   *                       \li &lt;name&gt;_edge for the corners
   *
   *                       If any of those ressources aren't found, it is left 
   *                       out. Defaults to dialogbox_frame
   *\param font font to use, defaults to Font()
   */
  MessageDialog(const std::string& title, const std::string& msg,
	     const std::string& border_res_name="dialogbox_frame",
	     const Font& font=Font())
	: BorderedDialog(title, border_res_name, font) {packBox(msg);}

  /**
   * Create a message box, just specifying the message
   *\overload
   *\param msg the message that should be displayed
   */
  MessageDialog(const std::string& msg) :
	BorderedDialog("", "dialogbox_frame", Font()) {packBox(msg);}

 private:
  void packBox(const std::string& msg);

};


}

#endif // !_MESSAGEBOX
