/*
 * NodeExtrusion.h
 *
 * Copyright (C) 1999 Stephen F. White, 2004 Wu qingwei
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_EXTRUSION_H
#define _NODE_EXTRUSION_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"
#include "MeshBasedNode.h"

class ProtoExtrusion : public Proto {
public:
		    ProtoExtrusion(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex beginCap;
    FieldIndex ccw;
    FieldIndex convex;
    FieldIndex creaseAngle;
    FieldIndex crossSection;
    FieldIndex endCap;
    FieldIndex orientation;
    FieldIndex scale;
    FieldIndex solid;
    FieldIndex spine;
};


class NodeExtrusion : public MeshBasedNode {
public:
		    NodeExtrusion(Scene *scene, Proto *proto);

    virtual int	    getType() const { return NODE_EXTRUSION; }
    virtual Node   *copy() const { return new NodeExtrusion(*this); }
    virtual int	    getNodeClass() const { return GEOMETRY_NODE; }

    void	    createMesh();
    virtual void    setField(int index, FieldValue *value);

    virtual void    drawHandles();
    virtual Vec3f   getHandle(int handle, int *constraint, int *field);
    virtual void    setHandle(int handle, const Vec3f &v );

    virtual bool    isInvalidChildNode(void) { return true; }

    fieldMacros(SFBool,     beginCap,     ProtoExtrusion)
    fieldMacros(SFBool,     ccw,          ProtoExtrusion)
    fieldMacros(SFBool,     convex,       ProtoExtrusion)
    fieldMacros(SFFloat,    creaseAngle,  ProtoExtrusion)
    fieldMacros(MFVec2f,    crossSection, ProtoExtrusion)
    fieldMacros(SFBool,     endCap,       ProtoExtrusion)
    fieldMacros(MFRotation, orientation,  ProtoExtrusion)
    fieldMacros(MFVec2f,    scale,        ProtoExtrusion)
    fieldMacros(SFBool,     solid,        ProtoExtrusion)
    fieldMacros(MFVec3f,    spine,        ProtoExtrusion)
};

#endif // _NODE_EXTRUSION_H
