/*
 * NodeTransform.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_TRANSFORM_H
#define _NODE_TRANSFORM_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif
#ifndef _MATRIX_H
#include "Matrix.h"
#endif

#include "SFMFTypes.h"
#include "resource.h"

class ProtoTransform : public Proto {
public:
		    ProtoTransform(Scene *scene);
    virtual Node   *create(Scene *scene);
    FieldIndex      center;
    FieldIndex      children;
    FieldIndex      rotation;
    FieldIndex      scale;
    FieldIndex      scaleOrientation;
    FieldIndex      translation;
    FieldIndex      bboxCenter;
    FieldIndex      bboxSize;
};

enum {
    TRANSLATION,
    TRANSLATION_X,
    TRANSLATION_Y,
    TRANSLATION_Z,
    ROTATION,
    ROTATION_X,
    ROTATION_Y,
    ROTATION_Z,
    SCALE_X,
    SCALE_Y,
    SCALE_Z,
    SCALE,
    CENTER_X,
    CENTER_Y,
    CENTER_Z,
    CENTER
};

class NodeTransform : public Node {
public:
		      NodeTransform(Scene *scene, Proto *proto);

protected:
		     ~NodeTransform();

public:
    virtual int	      getType() const { return NODE_TRANSFORM; }
    virtual Node     *copy() const { return new NodeTransform(*this); }
    virtual void      setField(int index, FieldValue *value);
    virtual void      drawHandles();
    virtual void      transform();
    virtual void      transformForHandle(int handle);

    virtual int       countPolygons(void);
    virtual int       countPrimitives(void);

    virtual void      flip(int index);

    virtual void      draw();
    virtual void      preDraw();
    virtual Vec3f     getHandle(int handle, int *constraint, int *field);
    virtual void      setHandle(int handle, const Vec3f &v);

    virtual int       getAnmationCommentID(void) 
                         { return IDS_ANIMATION_HELP_TRANSFORM; }

    virtual void      receiveEvent(int eventIn, double timestamp, FieldValue *value);
    void              getMatrix(float* matrix);
    const Quaternion &getQuat(void);
    void              setQuat(const Quaternion &quat);    
    const Vec3f      &getScale(void);
    const Vec3f      &getCenter(void);

    fieldMacros(SFVec3f,    center,           ProtoTransform)
    fieldMacros(MFNode,     children,         ProtoTransform)
    fieldMacros(SFRotation, rotation,         ProtoTransform)
    fieldMacros(SFVec3f,    scale,            ProtoTransform)
    fieldMacros(SFRotation, scaleOrientation, ProtoTransform)
    fieldMacros(SFVec3f,    translation,      ProtoTransform)
    fieldMacros(SFVec3f,    bboxCenter,       ProtoTransform)
    fieldMacros(SFVec3f,    bboxSize,         ProtoTransform)

protected:
    static void	      drawCone(GLUquadricObj *obj, float x, float y, float z);
    static void	      drawCone(GLUquadricObj *obj, float x, float y, float z,
                                                   float r, float b, float g);
    static void       drawSphere(GLUquadricObj *obj, float x, float y, float z);
    static void       drawSphere(GLUquadricObj *obj, float x, float y, float z,
                                                     float r, float b, float g);
    static void       drawAntiCone(GLUquadricObj *obj, 
                                                     float x, float y, float z);
    static void       drawAntiCone(GLUquadricObj *obj, 
                                                     float x, float y, float z,
                                                     float r, float b, float g);
    static void       drawCylinder(GLUquadricObj *obj, 
                                                     float x, float y, float z);
    static void       drawCylinder(GLUquadricObj *obj, 
                                                     float x, float y, float z,
                                                     float r, float b, float g);
    static void	      drawScaleHandle(float x, float y, float z);
    void	      drawAxisLines();
    void	      drawTranslationHandles();
    void	      drawRotationHandles();
    void	      drawScaleHandles();
    void	      drawCenterHandles();
    void	      draw6DHandles();
    void	      draw6DlocalHandles();
    void	      drawRocketHandles();
    void	      drawHoverHandles();
private:
    bool	      _matrixDirty;
    Matrix	      _matrix;
};

#endif // _NODE_TRANSFORM_H
