(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)
Require Export jessie_why. 
Require Import WhyFloatsStrict.
Require Import Interval_tactic.
Require Import Rtrigo_def.

(*Why type*) Definition charP: Set.
Admitted.

(*Why type*) Definition int8: Set.
Admitted.

(*Why type*) Definition padding: Set.
Admitted.

(*Why type*) Definition voidP: Set.
Admitted.

(*Why logic*) Definition charP_tag : (tag_id charP).
Admitted.

(*Why axiom*) Lemma charP_int : (int_of_tag charP_tag) = 1.
Admitted.
Dp_hint charP_int.

(*Why logic*) Definition charP_of_pointer_address :
  (pointer unit) -> (pointer charP).
Admitted.

(*Why axiom*) Lemma charP_of_pointer_address_of_pointer_addr :
  (forall (p:(pointer charP)),
   p = (charP_of_pointer_address (pointer_address p))).
Admitted.
Dp_hint charP_of_pointer_address_of_pointer_addr.

(*Why axiom*) Lemma charP_parenttag_bottom :
  (parenttag charP_tag (@bottom_tag charP)).
Admitted.
Dp_hint charP_parenttag_bottom.

(*Why axiom*) Lemma charP_tags :
  (forall (x:(pointer charP)),
   (forall (charP_tag_table:(tag_table charP)),
    (instanceof charP_tag_table x charP_tag))).
Admitted.
Dp_hint charP_tags.

(*Why logic*) Definition integer_of_int8 : int8 -> Z.
Admitted.

(*Why predicate*) Definition eq_int8  (x:int8) (y:int8)
  := (integer_of_int8 x) = (integer_of_int8 y).

(*Why logic*) Definition int8_of_integer : Z -> int8.
Admitted.

(*Why axiom*) Lemma int8_coerce :
  (forall (x:Z),
   ((-128) <= x /\ x <= 127 -> (integer_of_int8 (int8_of_integer x)) = x)).
Admitted.

(*Why axiom*) Lemma int8_extensionality :
  (forall (x:int8),
   (forall (y:int8), ((integer_of_int8 x) = (integer_of_int8 y) -> x = y))).
Admitted.
Dp_hint int8_extensionality.

(*Why axiom*) Lemma int8_range :
  (forall (x:int8), (-128) <= (integer_of_int8 x) /\ (integer_of_int8 x) <=
   127).
Admitted.

(*Why predicate*) Definition left_valid_struct_charP  (p:(pointer charP)) (a:Z) (charP_alloc_table:(alloc_table charP))
  := (offset_min charP_alloc_table p) <= a.

(*Why predicate*) Definition left_valid_struct_voidP  (p:(pointer voidP)) (a:Z) (voidP_alloc_table:(alloc_table voidP))
  := (offset_min voidP_alloc_table p) <= a.

(*Why axiom*) Lemma pointer_addr_of_charP_of_pointer_address :
  (forall (p:(pointer unit)),
   p = (pointer_address (charP_of_pointer_address p))).
Admitted.
Dp_hint pointer_addr_of_charP_of_pointer_address.

(*Why logic*) Definition voidP_of_pointer_address :
  (pointer unit) -> (pointer voidP).
Admitted.

(*Why axiom*) Lemma pointer_addr_of_voidP_of_pointer_address :
  (forall (p:(pointer unit)),
   p = (pointer_address (voidP_of_pointer_address p))).
Admitted.
Dp_hint pointer_addr_of_voidP_of_pointer_address.

(*Why predicate*) Definition right_valid_struct_charP  (p:(pointer charP)) (b:Z) (charP_alloc_table:(alloc_table charP))
  := (offset_max charP_alloc_table p) >= b.

(*Why predicate*) Definition right_valid_struct_voidP  (p:(pointer voidP)) (b:Z) (voidP_alloc_table:(alloc_table voidP))
  := (offset_max voidP_alloc_table p) >= b.

(*Why predicate*) Definition strict_valid_root_charP  (p:(pointer charP)) (a:Z) (b:Z) (charP_alloc_table:(alloc_table charP))
  := (offset_min charP_alloc_table p) = a /\
     (offset_max charP_alloc_table p) = b.

(*Why predicate*) Definition strict_valid_root_voidP  (p:(pointer voidP)) (a:Z) (b:Z) (voidP_alloc_table:(alloc_table voidP))
  := (offset_min voidP_alloc_table p) = a /\
     (offset_max voidP_alloc_table p) = b.

(*Why predicate*) Definition strict_valid_struct_charP  (p:(pointer charP)) (a:Z) (b:Z) (charP_alloc_table:(alloc_table charP))
  := (offset_min charP_alloc_table p) = a /\
     (offset_max charP_alloc_table p) = b.

(*Why predicate*) Definition strict_valid_struct_voidP  (p:(pointer voidP)) (a:Z) (b:Z) (voidP_alloc_table:(alloc_table voidP))
  := (offset_min voidP_alloc_table p) = a /\
     (offset_max voidP_alloc_table p) = b.

(*Why predicate*) Definition valid_root_charP  (p:(pointer charP)) (a:Z) (b:Z) (charP_alloc_table:(alloc_table charP))
  := (offset_min charP_alloc_table p) <= a /\
     (offset_max charP_alloc_table p) >= b.

(*Why predicate*) Definition valid_root_voidP  (p:(pointer voidP)) (a:Z) (b:Z) (voidP_alloc_table:(alloc_table voidP))
  := (offset_min voidP_alloc_table p) <= a /\
     (offset_max voidP_alloc_table p) >= b.

(*Why predicate*) Definition valid_struct_charP  (p:(pointer charP)) (a:Z) (b:Z) (charP_alloc_table:(alloc_table charP))
  := (offset_min charP_alloc_table p) <= a /\
     (offset_max charP_alloc_table p) >= b.

(*Why predicate*) Definition valid_struct_voidP  (p:(pointer voidP)) (a:Z) (b:Z) (voidP_alloc_table:(alloc_table voidP))
  := (offset_min voidP_alloc_table p) <= a /\
     (offset_max voidP_alloc_table p) >= b.

(*Why logic*) Definition voidP_tag : (tag_id voidP).
Admitted.

(*Why axiom*) Lemma voidP_int : (int_of_tag voidP_tag) = 1.
Admitted.
Dp_hint voidP_int.

(*Why axiom*) Lemma voidP_of_pointer_address_of_pointer_addr :
  (forall (p:(pointer voidP)),
   p = (voidP_of_pointer_address (pointer_address p))).
Admitted.
Dp_hint voidP_of_pointer_address_of_pointer_addr.

(*Why axiom*) Lemma voidP_parenttag_bottom :
  (parenttag voidP_tag (@bottom_tag voidP)).
Admitted.
Dp_hint voidP_parenttag_bottom.

(*Why axiom*) Lemma voidP_tags :
  (forall (x:(pointer voidP)),
   (forall (voidP_tag_table:(tag_table voidP)),
    (instanceof voidP_tag_table x voidP_tag))).
Admitted.
Dp_hint voidP_tags.

(* Why obligation from file "my_cosine.c", line 36, characters 4-111: *)
(*Why goal*) Lemma method_error : 
  (forall (x_3:R),
   ((Rle (Rabs x_3) (1 / 32)%R) ->
    (Rle
     (Rabs
      (Rminus (Rminus (1)%R (Rmult (Rmult x_3 x_3) (05 / 10)%R)) (cos x_3)))
     (1 / 16777216)%R))).
Proof.
intros x H.

interval with (i_bisect_diff x).
Save.

Dp_hint method_error.

(* Why obligation from file "my_cosine.c", line 44, characters 13-53: *)
(*Why goal*) Lemma my_cos1_ensures_default_po_1 : 
  forall (x_0: single),
  forall (HW_1: (* JC_3 *) (Rle (Rabs (single_value x_0)) (1 / 32)%R)),
  (* JC_13 *)
  (Rle
   (Rabs
    (Rminus
     (Rminus
      (1)%R (Rmult (Rmult (single_value x_0) (single_value x_0)) (05 / 10)%R)) (
     cos (single_value x_0))))
   (1 / 16777216)%R).
Proof.
intros x H.
interval with (i_bisect_diff (single_value x)).
Save.

(* Why obligation from file "my_cosine.c", line 41, characters 12-46: *)
(*Why goal*) Lemma my_cos1_ensures_default_po_2 : 
  forall (x_0: single),
  forall (HW_1: (* JC_3 *) (Rle (Rabs (single_value x_0)) (1 / 32)%R)),
  forall (HW_4: (* JC_13 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_0) (single_value x_0)) (05 / 10)%R)) (
                   cos (single_value x_0))))
                 (1 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_6: (mul_single_post nearest_even x_0 x_0 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_8: (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_9: (sub_single_post nearest_even result result2 result3)),
  forall (__retres: single),
  forall (HW_10: __retres = result3),
  forall (why__return: single),
  forall (HW_11: why__return = __retres),
  (* JC_5 *)
  (Rle (Rabs (Rminus (single_value why__return) (cos (single_value x_0))))
   (1 / 8388608)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 45, characters 16-21: *)
(*Why goal*) Lemma my_cos1_safety_po_1 : 
  forall (x_0: single),
  forall (HW_1: (* JC_3 *) (Rle (Rabs (single_value x_0)) (1 / 32)%R)),
  forall (HW_4: (* JC_9 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_0) (single_value x_0)) (05 / 10)%R)) (
                   cos (single_value x_0))))
                 (1 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value x_0) (single_value x_0))).
Proof.
admit.
Save.

(* Why obligation from file "my_cosine.c", line 45, characters 16-28: *)
(*Why goal*) Lemma my_cos1_safety_po_2 : 
  forall (x_0: single),
  forall (HW_1: (* JC_3 *) (Rle (Rabs (single_value x_0)) (1 / 32)%R)),
  forall (HW_4: (* JC_9 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_0) (single_value x_0)) (05 / 10)%R)) (
                   cos (single_value x_0))))
                 (1 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult (single_value x_0) (single_value x_0)))),
  forall (result0: single),
  forall (HW_7: (mul_single_post nearest_even x_0 x_0 result0)),
  forall (result1: single),
  forall (HW_8: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value result0) (single_value result1))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 45, characters 9-28: *)
(*Why goal*) Lemma my_cos1_safety_po_3 : 
  forall (x_0: single),
  forall (HW_1: (* JC_3 *) (Rle (Rabs (single_value x_0)) (1 / 32)%R)),
  forall (HW_4: (* JC_9 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_0) (single_value x_0)) (05 / 10)%R)) (
                   cos (single_value x_0))))
                 (1 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult (single_value x_0) (single_value x_0)))),
  forall (result0: single),
  forall (HW_7: (mul_single_post nearest_even x_0 x_0 result0)),
  forall (result1: single),
  forall (HW_8: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (HW_9: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1)))),
  forall (result2: single),
  forall (HW_10: (mul_single_post nearest_even result0 result1 result2)),
  (no_overflow_single
   nearest_even (Rminus (single_value result) (single_value result2))).
Proof.
admit.
Save.

(* Why obligation from file "my_cosine.c", line 52, characters 13-27: *)
(*Why goal*) Lemma my_cos2_ensures_default_po_1 : 
  forall (x_0_0: single),
  forall (HW_1: (* JC_23 *)
                ((* JC_21 *) (Rle (Rabs (single_value x_0_0)) (1 / 32)%R) /\
                (* JC_22 *) (eq (single_round_error x_0_0) (0)%R))),
  (* JC_34 *) (eq (single_exact x_0_0) (single_value x_0_0)).
Proof.
admit.
Save.

(* Why obligation from file "my_cosine.c", line 54, characters 13-49: *)
(*Why goal*) Lemma my_cos2_ensures_default_po_2 : 
  forall (x_0_0: single),
  forall (HW_1: (* JC_23 *)
                ((* JC_21 *) (Rle (Rabs (single_value x_0_0)) (1 / 32)%R) /\
                (* JC_22 *) (eq (single_round_error x_0_0) (0)%R))),
  forall (HW_4: (* JC_34 *) (eq (single_exact x_0_0) (single_value x_0_0))),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_6: (mul_single_post nearest_even x_0_0 x_0_0 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_8: (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_9: (sub_single_post nearest_even result result2 result3)),
  forall (r: single),
  forall (HW_10: r = result3),
  (* JC_38 *)
  (Rle (Rabs (Rminus (single_exact r) (cos (single_value x_0_0))))
   (1 / 16777216)%R).
Proof.
intros x (H1,H2) Heq.
intros r (_,(exa_r,_)).
intros r0 (_,(exa_r0,_)).
intros r1 (_,(exa_r1,_)).
intros r2 (_,(exa_r2,_)).
intros r3 (_,(exa_r3,_)).
intros r4 r4_eq.
subst r4.
rewrite exa_r3; clear exa_r3 r3.
rewrite exa_r2; clear exa_r2 r2.
rewrite exa_r1; clear exa_r1 r1.
rewrite exa_r0; clear exa_r0 r0.
rewrite exa_r; clear exa_r r.
unfold single_round_error in H2.
rewrite Heq.
interval with (i_bisect_diff (single_value x)).
Save.

(* Why obligation from file "my_cosine.c", line 49, characters 12-46: *)
(*Why goal*) Lemma my_cos2_ensures_default_po_3 : 
  forall (x_0_0: single),
  forall (HW_1: (* JC_23 *)
                ((* JC_21 *) (Rle (Rabs (single_value x_0_0)) (1 / 32)%R) /\
                (* JC_22 *) (eq (single_round_error x_0_0) (0)%R))),
  forall (HW_4: (* JC_34 *) (eq (single_exact x_0_0) (single_value x_0_0))),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_6: (mul_single_post nearest_even x_0_0 x_0_0 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_8: (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_9: (sub_single_post nearest_even result result2 result3)),
  forall (r: single),
  forall (HW_10: r = result3),
  forall (HW_11: (* JC_38 *)
                 (Rle
                  (Rabs (Rminus (single_exact r) (cos (single_value x_0_0))))
                  (1 / 16777216)%R)),
  forall (why__return: single),
  forall (HW_12: why__return = r),
  (* JC_25 *)
  (Rle (Rabs (Rminus (single_value why__return) (cos (single_value x_0_0))))
   (1 / 8388608)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 53, characters 19-24: *)
(*Why goal*) Lemma my_cos2_safety_po_1 : 
  forall (x_0_0: single),
  forall (HW_1: (* JC_23 *)
                ((* JC_21 *) (Rle (Rabs (single_value x_0_0)) (1 / 32)%R) /\
                (* JC_22 *) (eq (single_round_error x_0_0) (0)%R))),
  forall (HW_4: (* JC_29 *) (eq (single_exact x_0_0) (single_value x_0_0))),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value x_0_0) (single_value x_0_0))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 53, characters 19-31: *)
(*Why goal*) Lemma my_cos2_safety_po_2 : 
  forall (x_0_0: single),
  forall (HW_1: (* JC_23 *)
                ((* JC_21 *) (Rle (Rabs (single_value x_0_0)) (1 / 32)%R) /\
                (* JC_22 *) (eq (single_round_error x_0_0) (0)%R))),
  forall (HW_4: (* JC_29 *) (eq (single_exact x_0_0) (single_value x_0_0))),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult
                               (single_value x_0_0) (single_value x_0_0)))),
  forall (result0: single),
  forall (HW_7: (mul_single_post nearest_even x_0_0 x_0_0 result0)),
  forall (result1: single),
  forall (HW_8: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value result0) (single_value result1))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 53, characters 12-31: *)
(*Why goal*) Lemma my_cos2_safety_po_3 : 
  forall (x_0_0: single),
  forall (HW_1: (* JC_23 *)
                ((* JC_21 *) (Rle (Rabs (single_value x_0_0)) (1 / 32)%R) /\
                (* JC_22 *) (eq (single_round_error x_0_0) (0)%R))),
  forall (HW_4: (* JC_29 *) (eq (single_exact x_0_0) (single_value x_0_0))),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult
                               (single_value x_0_0) (single_value x_0_0)))),
  forall (result0: single),
  forall (HW_7: (mul_single_post nearest_even x_0_0 x_0_0 result0)),
  forall (result1: single),
  forall (HW_8: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (HW_9: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1)))),
  forall (result2: single),
  forall (HW_10: (mul_single_post nearest_even result0 result1 result2)),
  (no_overflow_single
   nearest_even (Rminus (single_value result) (single_value result2))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 66, characters 13-57: *)
(*Why goal*) Lemma my_cos3_ensures_default_po_1 : 
  forall (x_1: single),
  forall (HW_1: (* JC_45 *)
                ((* JC_43 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_44 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_5: (mul_single_post nearest_even x_1 x_1 result0)),
  forall (result1: single),
  forall (HW_6: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_7: (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_8: (sub_single_post nearest_even result result2 result3)),
  forall (r_0: single),
  forall (HW_9: r_0 = result3),
  (* JC_62 *)
  (Rle (Rabs (Rminus (single_exact r_0) (cos (single_exact x_1))))
   (1 / 16777216)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 61, characters 12-62: *)
(*Why goal*) Lemma my_cos3_ensures_default_po_2 : 
  forall (x_1: single),
  forall (HW_1: (* JC_45 *)
                ((* JC_43 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_44 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_5: (mul_single_post nearest_even x_1 x_1 result0)),
  forall (result1: single),
  forall (HW_6: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_7: (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_8: (sub_single_post nearest_even result result2 result3)),
  forall (r_0: single),
  forall (HW_9: r_0 = result3),
  forall (HW_10: (* JC_62 *)
                 (Rle
                  (Rabs (Rminus (single_exact r_0) (cos (single_exact x_1))))
                  (1 / 16777216)%R)),
  forall (why__return: single),
  forall (HW_11: why__return = r_0),
  (* JC_49 *)
  (* JC_47 *)
  (Rle (Rabs (Rminus (single_exact why__return) (cos (single_exact x_1))))
   (1 / 16777216)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 62, characters 11-61: *)
(*Why goal*) Lemma my_cos3_ensures_default_po_3 : 
  forall (x_1: single),
  forall (HW_1: (* JC_45 *)
                ((* JC_43 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_44 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_5: (mul_single_post nearest_even x_1 x_1 result0)),
  forall (result1: single),
  forall (HW_6: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_7: (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_8: (sub_single_post nearest_even result result2 result3)),
  forall (r_0: single),
  forall (HW_9: r_0 = result3),
  forall (HW_10: (* JC_62 *)
                 (Rle
                  (Rabs (Rminus (single_exact r_0) (cos (single_exact x_1))))
                  (1 / 16777216)%R)),
  forall (why__return: single),
  forall (HW_11: why__return = r_0),
  (* JC_49 *)
  (* JC_48 *)
  (Rle (single_round_error why__return)
   (Rplus (single_round_error x_1) (3 / 16777216)%R)).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 65, characters 19-24: *)
(*Why goal*) Lemma my_cos3_safety_po_1 : 
  forall (x_1: single),
  forall (HW_1: (* JC_45 *)
                ((* JC_43 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_44 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value x_1) (single_value x_1))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 65, characters 19-31: *)
(*Why goal*) Lemma my_cos3_safety_po_2 : 
  forall (x_1: single),
  forall (HW_1: (* JC_45 *)
                ((* JC_43 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_44 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_5: (no_overflow_single
                 nearest_even (Rmult (single_value x_1) (single_value x_1)))),
  forall (result0: single),
  forall (HW_6: (mul_single_post nearest_even x_1 x_1 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value result0) (single_value result1))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 65, characters 12-31: *)
(*Why goal*) Lemma my_cos3_safety_po_3 : 
  forall (x_1: single),
  forall (HW_1: (* JC_45 *)
                ((* JC_43 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_44 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_5: (no_overflow_single
                 nearest_even (Rmult (single_value x_1) (single_value x_1)))),
  forall (result0: single),
  forall (HW_6: (mul_single_post nearest_even x_1 x_1 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (HW_8: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1)))),
  forall (result2: single),
  forall (HW_9: (mul_single_post nearest_even result0 result1 result2)),
  (no_overflow_single
   nearest_even (Rminus (single_value result) (single_value result2))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 74, characters 13-55: *)
(*Why goal*) Lemma my_cos4_ensures_default_po_1 : 
  forall (x_2: single),
  forall (HW_1: (* JC_65 *) (Rle (Rabs (single_value x_2)) (007 / 100)%R)),
  (* JC_75 *)
  (Rle
   (Rabs
    (Rminus
     (Rminus
      (1)%R (Rmult (Rmult (single_value x_2) (single_value x_2)) (05 / 10)%R)) (
     cos (single_value x_2))))
   (15 / 16777216)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 71, characters 12-46: *)
(*Why goal*) Lemma my_cos4_ensures_default_po_2 : 
  forall (x_2: single),
  forall (HW_1: (* JC_65 *) (Rle (Rabs (single_value x_2)) (007 / 100)%R)),
  forall (HW_4: (* JC_75 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_2) (single_value x_2)) (05 / 10)%R)) (
                   cos (single_value x_2))))
                 (15 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_6: (mul_single_post nearest_even x_2 x_2 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_8: (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_9: (sub_single_post nearest_even result result2 result3)),
  forall (__retres_0: single),
  forall (HW_10: __retres_0 = result3),
  forall (why__return: single),
  forall (HW_11: why__return = __retres_0),
  (* JC_67 *)
  (Rle (Rabs (Rminus (single_value why__return) (cos (single_value x_2))))
   (1 / 1048576)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 75, characters 16-21: *)
(*Why goal*) Lemma my_cos4_safety_po_1 : 
  forall (x_2: single),
  forall (HW_1: (* JC_65 *) (Rle (Rabs (single_value x_2)) (007 / 100)%R)),
  forall (HW_4: (* JC_71 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_2) (single_value x_2)) (05 / 10)%R)) (
                   cos (single_value x_2))))
                 (15 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value x_2) (single_value x_2))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 75, characters 16-28: *)
(*Why goal*) Lemma my_cos4_safety_po_2 : 
  forall (x_2: single),
  forall (HW_1: (* JC_65 *) (Rle (Rabs (single_value x_2)) (007 / 100)%R)),
  forall (HW_4: (* JC_71 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_2) (single_value x_2)) (05 / 10)%R)) (
                   cos (single_value x_2))))
                 (15 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult (single_value x_2) (single_value x_2)))),
  forall (result0: single),
  forall (HW_7: (mul_single_post nearest_even x_2 x_2 result0)),
  forall (result1: single),
  forall (HW_8: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value result0) (single_value result1))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 75, characters 9-28: *)
(*Why goal*) Lemma my_cos4_safety_po_3 : 
  forall (x_2: single),
  forall (HW_1: (* JC_65 *) (Rle (Rabs (single_value x_2)) (007 / 100)%R)),
  forall (HW_4: (* JC_71 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_2) (single_value x_2)) (05 / 10)%R)) (
                   cos (single_value x_2))))
                 (15 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult (single_value x_2) (single_value x_2)))),
  forall (result0: single),
  forall (HW_7: (mul_single_post nearest_even x_2 x_2 result0)),
  forall (result1: single),
  forall (HW_8: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (HW_9: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1)))),
  forall (result2: single),
  forall (HW_10: (mul_single_post nearest_even result0 result1 result2)),
  (no_overflow_single
   nearest_even (Rminus (single_value result) (single_value result2))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.


