/*
 *  texture.h
 *
 *  Written by:		Ullrich Hafner
 *  
 *  Copyright (C) 1998 Ullrich Hafner <hafner@bigfoot.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 1999/08/08 20:09:11 $
 *  $Author: hafner $
 *  $Revision: 1.17 $
 *  $State: Exp $
 */

#ifndef _TEXTURE_H
#define _TEXTURE_H

#include "config.h"
#include <gtk/gtk.h>
#include <proplist.h>

enum sgradient_e {SGRADIENT_TYPE, SGRADIENT_COLOR1, SGRADIENT_COLOR2,
		  SGRADIENT_SPINNER, SGRADIENT_FRAME, SGRADIENT_LAST};
typedef enum {PIXMAP_TYPE, PIXMAP_NAME, PIXMAP_PIXMAP, PIXMAP_FRAME,
	      PIXMAP_TILEOFDAY, PIXMAP_SCALED, PIXMAP_TILED, PIXMAP_CENTERED,
	      PIXMAP_MAXASPECT, PIXMAP_LAST} pixmap_e;
typedef enum {GRADIENT_TYPE, GRADIENT_LIST, GRADIENT_REMOVE, GRADIENT_FRAME,
	      GRADIENT_HOR, GRADIENT_VER, GRADIENT_DIAG, GRADIENT_PREVIEW,
	      GRADIENT_LAST} gradient_e;
typedef enum {BILINEAR_FRAME, BILINEAR_NW, BILINEAR_NE, BILINEAR_SW, BILINEAR_SE,
	      BILINEAR_PREVIEW, BILINEAR_LAST} bilinear_e;
typedef enum {FADE_FRAME, FADE_FROM, FADE_TO, FADE_PREVIEW, FADE_LAST} fade_e;
typedef enum {WAVES_FRAME, WAVES_FROM, WAVES_TO, WAVES_LAYERS, WAVES_FREQUENCY,
	      WAVES_PREVIEW, WAVES_LAST} waves_e;
typedef enum {TEXTURE_SOLID, TEXTURE_GRADIENT, TEXTURE_PIXMAP, TEXTURE_TGRADIENT,
	      TEXTURE_NONE, TEXTURE_DEFAULT, TEXTURE_BILINEAR, TEXTURE_FADE,
	      TEXTURE_WAVES, TEXTURE_LAST} texture_e;

typedef struct wtexture
{
   GtkWidget  **wpixmap;
   GtkWidget  **wgradient;
   GtkWidget  **wsgradient;
   GtkWidget  *wttype;
   GtkWidget  *wwttype;
   GtkWidget  *wcolorbox;
   GtkWidget  *wcolor;
#ifdef HAVE_LIBWMFUN
   GtkWidget  **wfade;
   GtkWidget  **wbilinear;
   GtkWidget  **wwaves;
#endif
   proplist_t *key;
   proplist_t *wssback;
   unsigned   wsnumber;
   const char *path;
} wtexture_t;

GtkWidget *
texture_dialog (GtkWidget *box, GtkWidget *omenu_box, proplist_t *key);
GtkWidget *
color_button (wtexture_t *wtexture, proplist_t *key, proplist_t *color,
	      GtkTooltips *tooltips, const char *info);
void
fill_preview (GtkPreview *preview, const char *col_spec);
GtkWidget *
show_pixmap (proplist_t *key, const char *name, GtkWidget *pixmap);
void
verify_pixmap_name (GtkWidget *widget, wtexture_t *wtexture);
void
cleanup_textures (void);

#endif /* not _TEXTURE_H */

