#!/usr/bin/python


try:
  import os, sys
  if os.path.exists('/usr/lib/woody'):
    sys.path.append('/usr/lib/woody')
  from woody_defs import *
  import woody
except IOError, msg:
  print "Fatal Error loading program modules: %s" % msg
  sys.exit(1)
except ImportError, msg:
  print "Fatal Error loading program modules: %s" % msg
  sys.exit(1)


############################################################
#
#
def is_node(obj):
  return hasattr(obj,'is_node') and obj.is_node

class node:
  is_node = 1

  #
  # Each node contains...
  # - children
  # - expanded: should the list of children be visible?
  # - todo type: none, todo, or progress
  # - todo status: done, not done, percentage
  # - text
  # - note
  # - priority
  def __init__(self, text=None, note=None, todo=None, done=0,
               expanded=1, priority=""):
    self.children = []
    self.text = text
    self.note = note
    self.todo = todo # may be None, "todo", or "progress"
    self.done = done
    self.expanded = expanded
    self.priority = priority
    self.autosort = None
    self.hidden = 0
    self.parent = None

  def add(self, add):
    #print "Adding node..."
    if self.parent:
      next = self.parent.get_next_node(self)
      if next:
        #print "case 1"
        self.parent.insert(add, next)
      else:
        #print "case 2"
        self.append(add)
      return add
    else:
      #print "case 3"
      return self.append(add)

  def append(self, add):
    if self.parent:
      self.parent.extend(add)
    else:
      self.extend(add)

  def extend(self, add):
    add.parent = self
    self.children.append(add)
    if self.todo == "progress"  and  add.todo:
      self.recalc_progress()

  def insert(self, add, prev):
    add.parent = self
    if prev == None:
      self.children.insert(0, add)
      if self.todo == "progress"  and  add.todo:
        self.recalc_progress()
      return
    for i in range(len(self.children)):
      if self.children[i] == prev:
        self.children.insert(i, add)
        if self.todo == "progress"  and  add.todo:
          self.recalc_progress()
        return
    self.children.append(add)

  def insert_after(self, add, prev):
    add.parent = self
    for i in range(len(self.children)):
      if self.children[i] == prev:
        self.children.insert(i+1, add)
        if self.todo == "progress"  and  add.todo:
          self.recalc_progress()
        return
    self.children.append(add)

  def sort(self, method):
    if method == "name":
      self.children.sort(node_name_cmp)
    elif method == "priority":
      self.children.sort(node_priority_cmp)
    elif method == "duedate":
      self.children.sort(node_duedate_cmp)
    # TODO: more sorting methods?
    for child in self.children:
      child.sort(method)

  # TODO: optimize this..
  def vis_count(self):
    if self.hidden: return 0
    elif not self.expanded: return 1
    else:
      count = 1
      for child in self.children:
        if not child.hidden:
          count = count + child.vis_count()
      return count

  ##### return item numbered "which" from the tree
  def get_node(self, which):
    #print "get_node(%s) %s" % (which, self)
    count = 0
    if not self.expanded:
      if which != 0:
        return None
      return self

    for child in self.children:
      if not child.hidden:
        if count == which:
          return child
        else:
          size = child.vis_count()
          count = count + 1
          if which < size + count:
            return child.get_node(which - count)
          else:
            count = count + size
    return None

  ##### return item named "which" from the tree
  # Search is depth-first
  def get_node_name(self, which):
    for child in self.children:
      if which == child.name:
        return child
      else:
        if child.type != "node":
          name = child.get_node_name(which)
          if name: return name
    return None

  ##### return item named "which" from the tree
  # Search is depth-first
  def get_num_node(self, wood, which):
    vlist = self.vis_list(wood)
    count = 0
    for item in vlist:
      (n, depth) = item
      #print "Depth: %s Node: (%s, %s) == %s?" % (depth, n.text, n, which)
      if n == which:
        return count
      count = count + 1
    return -1

  def makeflat(self):
    plist = [self]
    if self.type == "node":
      return plist
    else:
      for child in self.children:
        if child.type == "node":
          plist.append(child)
        else:
          plist.extend(child.makeflat())
      return plist

  #####
  # each item is (node, depth) where node is a node()
  # and depth is how deep it is in the tree...
  def vis_list(self, wood, depth=-1):
    if self.hidden:  return []
    if self.todo  and  \
       self.done >= 1  and  \
       not wood.options.show_done_items:
      return []
    vlist = [(self, depth)]
    if not self.expanded:
      return vlist
    else:
      for child in self.children:
        if child.children  and  child.expanded:
          vlist.extend(child.vis_list(wood, depth+1))
        else:
          if not child.hidden:
            if not child.todo  or  \
               child.done < 1  or  \
               wood.options.show_done_items:
              vlist.append((child, depth+1))
      return vlist


  #####
  def cut(self, which):
    for i in range(len(self.children)):
      child = self.children[i]
      if child == which:
        del self.children[i]
        if self.todo == "progress"  and  which.todo:
          self.recalc_progress()
        return child

  #####
  def get_previous_node(self, which):
    prev = None
    for child in self.children:
      if child == which:
        #print "Node before %s is %s" % (which.text, prev.text)
        return prev
      prev = child
    #print "Couldn't find node before %s" % (which.text)
    return None
        
  #####
  def get_next_node(self, which):
    prev = None
    for child in self.children:
      if prev == which:
        return child
      prev = child
        
  #####
  def move_left(self):
    if self.parent and self.parent.parent:
      #print "Moving node \"%s\" left..." % self.text
      next = self.parent.parent.get_next_node(self.parent)
      self.parent.cut(self)
      if next:
        self.parent.parent.insert(self, next)
      else:
        self.parent.parent.insert_after(self, next)
    else:
      #print "Cannot move node \"%s\" left!" % self.text
      pass

  #####
  def move_right(self):
    if self.parent:
      new_parent = self.parent.get_previous_node(self)
      #print "new_parent: %s" % new_parent.text
      if new_parent:
        #print "Moving node \"%s\" right..." % self.text
        self.parent.cut(self)
        new_parent.extend(self)
      else:
        #print "Cannot move node \"%s\" further to the right!" % self.text
        pass
    else:
      #print "Cannot move node \"%s\" right!" % self.text
      pass

  #####
  def move_down(self):
    if self.parent:
      next = self.parent.get_next_node(self)
      if next:
        # If we're moving down and right...
        if next.children  and  next.expanded:
          self.parent.cut(self)
          next.insert(self, None)
        # If we're moving straight down...
        else:
          self.parent.cut(self)
          self.parent.insert_after(self, next)
      # We're moving down and left...
      else:
        found = 0
        parent = self
        child = self
        # climb the tree left until we find a spot we can go down..
        while not found:
          parent = parent.parent
          # If no parent, we hit root, and there was some sort of error
          # (for example, we're at the bottom of the tree)
          if not parent:
            return self.move_left()
            #raise "TreeError", "Error trying to move node %s down" % self.text
          next = parent.get_next_node(child)
          if next:
            found = 1
            self.parent.cut(self)
            if next.children  and  next.expanded:
              next.insert(self, None)
            else:
              parent.insert(self, next)
          else:
            child = parent

  #####
  def move_up(self):
    if self.parent:
      prev = self.parent.get_previous_node(self)
      if prev:
        # move up and right
        if prev.children  and  prev.expanded:
          found = 0
          parent = prev
          while not found:
            if parent.children  and  parent.expanded:
              parent = parent.children[-1]
            else:
              found = 1
              self.parent.cut(self)
              parent.append(self)
        # move straight up
        else:
          self.parent.cut(self)
          self.parent.insert(self, prev)
      else:
        # move up and left
        if self.parent.parent:
          self.parent.cut(self)
          self.parent.parent.insert(self, self.parent)
        # Or, if we hit the top of the tree...
        else:
          return
          #raise "TreeError", "No grandparent!"


  #####
  #
  def expand_collapse(self, tree=None):
    if self.expanded:
      self.collapse(tree)
    else:
      self.expand(tree)

  #####
  #
  def expand(self, tree=None):
    self.expanded = 1
    if tree  and  tree.options.autocollapse:
      tree.collapse_all()

      parent = self
      while parent.parent:
        parent.expanded = 1
        parent = parent.parent
      

  #####
  #
  def collapse(self, tree=None):
    if len(self.children) > 0:
      self.expanded = 0

  #####
  #
  def collapse_all(self):
    self.collapse()
    for child in self.children:
      child.collapse_all()

  #####
  #
  def recalc_progress(self):
    if self.todo != "progress":
      return
    if self.children:
      num_items = 0
      total_done = 0.0
      for child in self.children:
        if child.todo:
          num_items = num_items + 1
          #if child.children  and  child.todo == "progress":
          #  child.recalc_progress()
          if child.todo == "todo"  and  child.done:
            total_done = total_done + 1.0
          else:
            total_done = total_done + child.done
      if num_items > 0:
        self.done = float(total_done) / float(num_items)
    if self.parent  and  self.parent.todo == "progress":
      self.parent.recalc_progress()


  def remove_node(self, which):
    for i in range(len(self.children)):
      if self.children[i] == which:
        print "Deleting %s" % self.children[i].text
        del self.children[i]
        return
        

  def destroy(self):
    if self.todo  and  self.parent:
      self.todo = None
      self.parent.recalc_progress()
    if self.parent:
      self.parent.remove_node(self)
    for child in self.children:
      child.destroy()


  #####
  #
  def len(self):
    count = len(self.children)
    for child in self.children:
      count = count + child.len()

    return count

  #####
  #
  def import_tree(self, filename, cfg, callback=None):
    import woody_xml
    if not filename:
      filename = "test.tree"
    oak = woody_xml.load(cfg, filename, callback)
    title = oak.children.text
    self.add(oak.children)
    del oak


############################################################
#
def is_tree(obj):
  return hasattr(obj,'is_tree') and obj.is_tree

class tree:
  is_tree = 1

  #
  # Tree contains...
  # - one title node (which has children...)
  # - filename
  # - options...
  # - object count?
  # - editcount: num times edited
  # - creation date
  # - modification date
  #
  def __init__(self, cfg=None, title="", filename="tmp.tree",
               callback=None):
    import os.path
    self.cfg = cfg
    self.children = node(text=title)
    self.filename = filename
    if os.path.exists(filename):
      self.fullfilename = os.path.abspath(filename)
    else:
      self.fullfilename = os.getcwd() + "/" + filename
    self.callback = callback
    self.options = options(cfg)
    self.child_count = 0
    self.edit_count = 0
    self.creation_date = None
    self.modification_date = None
    self.modified = 0

  ##### Add a new node to the top level...
  def add(self, n=None):
    self.modified = 1
    if n:
      self.children.add(n)
    else:
      n = node()
      self.children.add(n)
    return n

  ##### Sort the entire tree, according to whatever node_cmp says...
  def sort(self, method):
    self.modified = 1
    self.children.sort(method)

  ##### Figure out how many items in the tree are visible to the user
  # (collapsed branch contents are invisible)
  def vis_count(self):
    self.child_count = self.children.vis_count()
    return self.child_count

  ##### return item numbered "which" from the tree
  # Search is depth-first
  def get_node(self, which):
    return self.children.get_node(which)

  ##### return item named "which" from the tree
  # Search is depth-first
  def get_node_name(self, which):
    return self.children.get_node_name(which)

  ##### return item named "which" from the tree
  # Search is depth-first
  def get_num_node(self, which):
    return self.children.get_num_node(self, which)

  #####
  #
  def collapse_all(self):
    self.modified = 1
    self.children.collapse_all()
    self.children.expand()

  ##### Create a flat display list
  # (traversing the tree while rendering the screen is *slow*!)
  def makeflat(self):
    return self.children.makeflat()

  ##### Create a flat display list
  # (traversing the tree while rendering the screen is *slow*!)
  def vis_list(self):
    vlist = self.children.vis_list(self)
    vlist = vlist[1:]
    return vlist

  #####
  #
  def save(self, filename=None):
    import woody_xml
    if not filename:
      filename = self.fullfilename
    print "Saving %s..." % filename
    woody_xml.save(self, filename, self.callback)
    self.modified = 0

  #####
  #
  def save_text(self, filename=None):
    import woody_text
    woody_text.save(self, filename)

  #####
  #
  def len(self):
    return self.children.len()



############################################################
#
#
def node_to_str(wood, branch, depth, wid=-1):
  import string
  line = ''


  note_text = "(NOTE)"
  
  expanded = " # "
  #if not wood.options.show_todo:
  #  expanded = " - "
  if len(branch.children) > 0:
    if branch.expanded:
      expanded = "[-]"
    else:
      expanded = "[+]"
  line = line + expanded

  indent_unit = 3

  if wood.options.show_priorities:
    #indent_unit = indent_unit + 4
    if branch.priority:
      pri = "(%s) " % branch.priority
    else:
      pri = "(_) "
    line = line + pri

  if wood.options.show_todo:
    indent_unit = indent_unit + 1
    todo = "  - "
    if branch.todo:
      if branch.todo == "todo":
        checked = "*"
        if not branch.done:
          checked = " "
        todo = " <%s>" % checked
      elif branch.todo == "progress":
        percent = "%2.0f%%" % (branch.done * 100.0)
        todo = "%4s" % percent
    line = line + todo


  indent = " " * indent_unit * depth

  if branch.text:
    if wood.options.only_first_line:
      foo = string.split(branch.text, "\n")
      text = foo[0]
      # if the text doesn't fit...
      over = 0
      if wid > 0:
        over = wid - len(line) - 1 - len(text) - len(indent)
        if over < 0:
          text = text[:over]

      if branch.note:
        if over == 0:
          text = text + " " + note_text
        elif over > len(note_text):
          text = text + (" " * (over - len(note_text))) + note_text
        else:
          max = wid - len(line) - 1 - len(note_text) - len(indent)
          text = text[:max] + note_text
          
    else:
      if wid > 0:
        max_wid = wid - len(line) - 1 - len(indent)
      else:
        max_wid = -1

      if branch.note:
        lines = wordwrap(branch.text, max_wid - len(note_text))
      else:
        lines = wordwrap(branch.text, max_wid)
        
      text = lines[0]
      del lines[0]

      if branch.note:
        under = max_wid - len(note_text) - len(text)
        text = text + (" " * under) + note_text
          
      for item in lines:
        text = text + "\n" + (" " * (wid - max_wid)) + item
      
  else:
    text = "-=(Empty)=-"
    over = 0
    if wid > 0:
      over = wid - len(line) - 1 - len(text) - len(indent)
      if over < 0:
        text = text[:over]

    if branch.note:
      if over == 0:
        text = text + " " + note_text
      elif over > len(note_text):
        text = text + (" " * (over - len(note_text))) + note_text
      else:
        max = wid - len(line) - 1 - len(note_text) - len(indent)
        text = text[:max] + note_text

  line = line + " " + text

  line = indent + line

  while line[-1] == " ":
    line = line[:-1]

  return line


############################################################
#
#
def wordwrap(str, wid):
  import string

  result = []
  
  lines = string.split(str, "\n")
  i = 0
  for line in lines:
    if wid <= 0  or  len(line) <= wid:
      result.append(line)
    else:
      raw = line[:wid]
      index = string.rfind(raw, " ")
      if index > 1:
        result.append(raw[:index])
        while line[index] == " ":
          index = index + 1
        lines.insert(i+1, line[index:])
      else:
        result.append(raw)
        lines.insert(i+1, line[wid:])
    i = i + 1

  #print "Result: %s" % result
  return result


############################################################
#
def is_options(obj):
  return hasattr(obj,'is_options') and obj.is_options

class options:
  is_options = 1

  # - options:
  #   - show only first line
  #   - show notes
  #   - show due dates
  #   - show priorities
  #   - show numbering
  #   - show done items
  #   ? sort type: off, name, priority, date, etc...
  #   - BF tree type: normal, or project
  #   - new items are what type?
  def __init__(self, cfg):
    self.only_first_line = 0
    self.show_notes = 0
    self.show_due_dates = 0
    self.show_priorities = 0
    self.show_todo = 1
    self.show_numbering = 0
    self.show_done_items = 1
    self.new_items = "normal"
    self.autocollapse = 0
    self.BF_tree_type = "normal"
    self.external_editor = "jed %f"
    if cfg  and  cfg.options.has_key("external editor"):
      self.external_editor = cfg.options["external editor"]
    self.editor = None
    self.note_editor = 1


############################################################
#
#
# TODO: more sorting functions...
def node_name_cmp(a,b):
  return cmp(a.text, b.text)
  
def node_name_rcmp(a,b):
  return -cmp(a.text, b.text)
  

