/* functionproto.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: functionproto.h,v 1.7 2001/11/03 17:10:09 ralf Exp $ */

#ifndef FUNCTIONPROTO_H
#define FUNCTIONPROTO_H

#include "wdefines.h"

class Datei;
class Worker;
class AGUIX;
class WCGlobalFlags;
class Lister;

class ActionMessage
{
public:
  ActionMessage();
  ~ActionMessage();
  WCGlobalFlags *flags;
  
  typedef enum {AM_MODE_NORMAL,
                AM_MODE_ONLYACTIVE,
                AM_MODE_DNDACTION,
                AM_MODE_SPECIAL} am_mode_t;
  am_mode_t mode;
  Lister *startLister;
  void *extraInfo;
};

class FunctionProto
{
public:
  FunctionProto(Worker*);
  virtual ~FunctionProto();
  virtual int configure();
  virtual int load(Datei*);
  virtual FunctionProto *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual bool save(Datei *);
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
  
  static FunctionProto *preload(Worker*,Datei*);
  static int presave(Datei*,FunctionProto*);
protected:
  static const char *name;
  Worker *worker;
  ActionMessage *am;
};

#endif
