/* fieldlistview.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: fieldlistview.h,v 1.24 2004/10/27 20:39:08 ralf Exp $ */

#ifndef NEWLISTVIEW_H
#define NEWLISTVIEW_H

#include "aguixdefs.h"
#include "util.h"
#include "guielement.h"
#include "fieldlvrowdata.h"
#include <string>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/X.h>

class AGUIX;
class AGUIXFont;

class FieldListView:public GUIElement
{
public:
  FieldListView( AGUIX *caguix, int cx, int cy, int cwidth, int cheight, int cdata );
  virtual ~FieldListView();
  FieldListView( const FieldListView &other );
  FieldListView &operator=( const FieldListView &other );

  void setNrOfFields( int nv );
  void setText( int row, int field, std::string text );
  std::string getText( int row, int field ) const;
  void trimElements();
  void setFieldWidth( int field, int width );
  void setFieldWidthQ( int field, int width );
  void setSize( int rows ); // create/delete needed rows
  int getUsedWidth( int field );
  int addRow();
  int deleteRow( int row );
  int insertRow( int row );
  void swapRows( int row1, int row2 );

  void setXOffset( int nv );
  int getMaxTextWidth();
  void setYOffset( int nv );

  typedef enum { ALIGN_LEFT, ALIGN_RIGHT } align_t;

  void setFieldAlign( int field, align_t nv );
  void setFieldAlignQ( int field, align_t nv );

  void setFieldTextQ( int field, const std::string nv );
  void setFieldText( int field, const std::string nv );

  // true to merge with following field text
  void setFieldTextMergedQ( int field, bool nv );
  void setFieldTextMerged( int field, bool nv );

  virtual void redraw();
  void redraw( int element );
  void redrawContent();
  typedef enum { CC_NORMAL = 0, CC_SELECT = 1, CC_ACTIVE = 2, CC_SELACT = 3 } colorclass_t;
  void setFG( int row, colorclass_t cc, int col );
  int getFG( int row, colorclass_t cc ) const;
  void setBG( int row, colorclass_t cc, int col );
  int getBG( int row, colorclass_t cc ) const;
  void setSelect( int row, bool nv );
  void setSelectQ( int row, bool nv );
  bool getSelect( int row ) const;
  void setActiveRow( int nv );
  void setActiveRowQ( int nv );
  int getActiveRow() const;

  void setVisMark( int row, bool nv );
  void setVisMarkQ( int row, bool nv );
  bool getVisMark( int row ) const;

  virtual void resize( int w, int h );
  int getData() const;
  void setData( int );
  virtual void flush();
  virtual bool handleMessage( XEvent *E, Message *msg );
  int getXOffset() const;
  int getYOffset() const;
  int getElements() const;
  int getMaxLen();
  int getMaxDisplayV() const;
  int getMaxDisplayH() const;
  void setHBarState( int state );
  void setVBarState( int state );
  int getHBarState() const;
  int getVBarState() const;
  void setVBarWidth( int new_width );
  int getVBarWidth() const;
  void setHBarHeight( int new_height );
  int getHBarHeight() const;
  void scrollV( int delta );
  void scrollV1( int dir );
  void setSelectHandler( void (*nsh)( FieldListView*, int element ) );
  void showActive();
  void centerActive();
  int setFont (char* );
  virtual const char *getType() const;
  virtual bool isType( const char *type ) const;
  virtual bool isParent( Window ) const;
  int getRowHeight() const;
  int getMBG() const;
  void setMBG( int color );
  
  int maximizeX();
  int maximizeY();

  void showRow( int row );
  
  void setData( int row, int ndata );
  int getData( int row ) const;
  void setDataExt( int row, FieldLVRowData *ndata );
  FieldLVRowData *getDataExt( int row ) const;
  
  bool isValidRow( int row ) const;

  typedef enum { PRECOLOR_NORMAL, PRECOLOR_ONLYSELECT, PRECOLOR_ONLYACTIVE, PRECOLOR_NOTSELORACT } precolor_t;
  void setPreColors( int row, precolor_t mode );
  void setDisplayFocus( bool nv );
  bool getDisplayFocus() const;

  void cond_redraw();
  bool isRowVisible( int row ) const;

  void setShowHeader( bool nv );
  bool getShowHeader() const;
  int getHeaderHeight() const;
  void redrawHeader();
  void setHeaderFG( int col );
  void setHeaderBG( int col );
  int getHeaderFG() const;
  int getHeaderBG() const;
protected:
  int fields;
  int *fieldwidth;
  int *used_width;
  int *maxrow;

  align_t *fieldalign;
  std::string *fieldtext;
  bool *fieldtextmerged;
  int fieldtextclicked;

  class Content
  {
  public:
    Content();
    ~Content();
    Content( const Content &other );
    Content &operator=( const Content &other );
    void setText( int field, std::string text );
    void trim( int newfields );
    std::string getText( int field ) const;
    int getLength( int field ) const;
    void setFG( colorclass_t cc, int col );
    int getFG( colorclass_t cc ) const;
    void setBG( colorclass_t cc, int col );
    int getBG( colorclass_t cc ) const;
    void setSelect( bool nv );
    bool getSelect() const;
    void setDataExt( FieldLVRowData *ndata );
    FieldLVRowData *getDataExt() const;
    void setData( int ndata );
    int getData() const;
    void setMark( bool nv );
    bool getMark() const;
  protected:
    int cur_fields;
    std::string **texts;

    int fg[4], bg[4];
    bool select;
    int data;
    FieldLVRowData *dataExt;
    bool mark;
  };
  Content **elementarray;
  int arraysize;
  int elements;

  void increaseArray( int newsize );
  void checkShrink();

  int xoffset, yoffset, maxdisplayh, maxdisplayv;

  void redraw( int element, char *line );
  int activerow;

  int data;
  static const char *type;
  bool bgset;
  int hbar;
  int hbar_height;
  int hbar_dir;
  bool hbar_pressed;
  int vbar;
  int vbar_width;
  int vbar_dir;
  bool vbar_pressed;
  void mredraw();
  void hbarredraw();
  void vbarredraw();
  Window hbarwin,vbarwin;
  void clearNonElements();
  void handleExpose( Window msgwin, int ex, int ey, int ew, int eh );
  virtual void handleSelect( Message *msg );
  virtual void handleMiddle( Message *msg );
  void handleThird( Message *msg );
  void handleHBar( Message *msg );
  void handleVBar( Message *msg );
  bool handleKeys( Message *msg );
  void handleHeader( Message *msg, int f );

  void (*selecthandler)( FieldListView*,int element );
  void setupBars();
  virtual void runSelectHandler( int element );
  void recalcMaxValues();
  
  AGUIXFont *font;
  struct timeval lastwheel;
  int mbg;

  int elementHeight, elementWidth, ox, oy;
  void resetWin( bool doRedraw );
  int getRowForMouseY( int my ) const;

  Pixmap buffer;
  void drawBuffer();
  void drawBuffer( int dx, int dy, int dw, int dh );
  void drawBuffer( int element );

  bool displayFocus;
  int getInnerWidth() const;
  int getInnerHeight() const;

  virtual void doCreateStuff();
  virtual void doDestroyStuff();

  bool cond_changed;
  bool showHeader;
  int headerCols[2];

  int getFieldForPoint( int mx, int my);

  typedef enum { VBAR_IDLE, VBAR_SCROLL, VBAR_SCROLL_UP, VBAR_SCROLL_DOWN } vbarMode_t;
  vbarMode_t vbarMode;
  int grabs;
  int scrollDelta;
  typedef enum { HBAR_IDLE, HBAR_SCROLL, HBAR_SCROLL_LEFT, HBAR_SCROLL_RIGHT } hbarMode_t;
  hbarMode_t hbarMode;
  typedef enum { THIRD_IDLE, THIRD_SCROLL } thirdMode_t;
  thirdMode_t thirdMode;
  int scrollXDir, scrollYDir;
  void updateScrollValues( int mx, int my );
  int selectRowsRange( int startRow, int endRow, bool state );
  typedef enum { SELECT_IDLE, SELECT_HOLD, SELECT_SCROLL_UP, SELECT_SCROLL_DOWN, SELECT_IGNORE } selectMode_t;
  selectMode_t selectMode;
  int clickLastSelectedRow, clickFirstSelectedRow;
  bool clickState;
  int clickSelected;
  typedef enum { MIDDLE_IDLE, MIDDLE_HOLD, MIDDLE_SCROLL_UP, MIDDLE_SCROLL_DOWN, MIDDLE_IGNORE } middleMode_t;
  middleMode_t middleMode;

  void selectModeIgnore();
  void middleModeIgnore();
};

#endif
