// $Id: Command.h,v 1.2 2001/10/14 22:24:47 zongo_fr Exp $
#ifndef WE_COMMAND_H
#define WE_COMMAND_H

#include <string>


class Command
{
  public:
    virtual ~Command() {}

    /**
     * Return a type id for the command(ie "HeightChange", "GroundChange",
     * "EntityAdd").
     *
     * This type is purely informative, to be used in UI and should not be 
     * relied upon for programming purposes.
     */
    virtual std::string Type() const = 0;

    /// Execute this command.
    virtual void Execute() = 0;

    /// Undo the action done by this command.
    virtual void Unexecute() = 0;

    /// Check whether the command is undoable
    // By default all commands are, redeclare IsUndoable in a derived class to
    // return 'false' if you want the Command to be non-undoable.
    virtual bool IsUndoable() const { return true; }

};


#endif // WE_COMMAND_H
