/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef FSK441Receive_H
#define	FSK441Receive_H

#include <wx/thread.h>

#include "common/Receive.h"
#include "common/Average.h"
#include "common/SoundDev.h"
#include "common/SoundFile.h"
#include "common/FFT.h"

#include "FSK441Levels.h"
#include "FSK441BurstData.h"
#include "FSK441Message.h"
#include "FSK441Defs.h"

class CFSK441Receive : public CReceive {

    public:
	CFSK441Receive(const wxString& name, EWho who);
	virtual ~CFSK441Receive();

	virtual void reset(bool firstTime);
	virtual void run();

	virtual void       openSoundDevice() = 0;
	virtual ISoundDev* getSoundDevice() = 0;
	virtual void       closeSoundDevice() = 0;

	virtual bool getEndTime() = 0;

	virtual void recordAudio(const wxString& id, double* audioData, int length) const = 0;

	virtual wxString createId() = 0;

    private:
	wxString         m_id;
	double*          m_audioSamples;
	int              m_samplesCount;
	CFFT             m_fft;
	int              m_DF;
	CAverage         m_noise;
	CFSK441BurstData m_burstData;
	int              m_minLength;
	int              m_minStrength;
	int              m_maxOffset;

	int  seekBurst(double* bins);
	int  storeBurst(double* bins);
	void decodeBurst();
	void getLevels() const;
};

#endif
