# -*- coding: utf-8 -*-
# vim:fenc=utf-8

# Copyright (C) 2012-2020 by Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
#
# X2Go Session Broker is free software; you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# X2Go Session Broker is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

class X2GoBrokerAuthMech(object):
    """\
    Base *authentication mechanism* class. This class is not supposed to
    be used as an authentication mechanism in running setups. (It let's
    authentication always fail).

    It is rather so, that more specific authentication mechanisms should
    inherit from this class. All features common to more specific
    authentication mechanisms go in here.
    """

    ### FIXME: Currently we don't let the other authmech classes inherit
    # from this class. Technically, this is ok as we override everything in
    # here in the sub-classes anyway. However, this should be fixed...
    #
    # E.g. the unit tests fail if tests.X2GoBrokerAuthMech inherits from
    # base.X2GoBrokerAuthMech. This needs some investigation.

    def authenticate(self, username, password, **kwargs):
        """\
        Dummy :func:`authenticate()` method of :class:`X2GoBrokerAuthMech`.

        :param username: The broker username sent by the client (ignored)
        :type username: ``str``
        :param password: The broker password sent by the client (ignored)
        :type password: ``str``
        :param kwargs: Any other parameter (for future features' compatibility, all ignored for now)
        :type kwargs: ``dict``

        :returns: Authentication failure (always!)
        :rtype: ``bool``

        """
        return False
