/* ########################################################################

				 tbox.c

   File: tbox.c
   Path: /home/lf/c/X11/xcoral-3.2b/tbox.c
   Description: 
   Created: Sun Apr 16 21:10:28 CEST 2000
   Author: Lionel Fournigault
   Modified: Sun Apr 16 21:10:28 CEST 2000
   Last maintained by: Lionel Fournigault

   RCS $Revision$ $State$
   

   ########################################################################

   Note: 

   ########################################################################

   Copyright (c) : Lionel Fournigault

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ######################################################################## */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "xcoral.h"
#include "options.h" 
#include "xc_conf.h" 
#include "tbox.h" 

extern Display *dpy;
static  Atom trombines_del;
static  int display_tbox = True;

XImage *image[3];
XImage * LoadImage16 ();
XImage * LoadImage256 ();

int no_image = False;
XVisualInfo visual_tmpl, *visual_list;

FCT (static void, UpdateTrombinesTitle, () );

/*
**	Function name : initTroncheBox
**
**	Description :
**	Input :
**	Output :
*/
void InitTrombinesBox() 
{
    XWindowAttributes att;
    Window root;
    int screen;
    int depth;
    unsigned long black, white;
    XGCValues	 gcv;
    XSizeHints sizehints;
    int visual_matched, i;
    
    black = BlackPixel ( dpy, DefaultScreen ( dpy ));
    white = WhitePixel ( dpy, DefaultScreen ( dpy ));

    trombines_box.fg = (DefaultDepth ( dpy, DefaultScreen ( dpy )) == 1) ? 
      black : GetOpColor ( OP_MENU_FG );
    trombines_box.bg = (DefaultDepth ( dpy, DefaultScreen ( dpy )) == 1) ?
      white : GetOpColor ( OP_MENU_BG );
    
    trombines_box.ts = GetOpColor ( OP_MENU_TS );
    trombines_box.bs = GetOpColor ( OP_MENU_BS );
    trombines_box.font = LoadFont ( dpy, DBOX_FONT );
    trombines_box.gc = XCreateGC ( dpy, DefaultRootWindow ( dpy ), 0,  &gcv );

    XSetFont ( dpy, trombines_box.gc, trombines_box.font -> fid );
    XSetForeground ( dpy, trombines_box.gc, trombines_box.fg );
    XSetBackground ( dpy, trombines_box.gc, trombines_box.bg );

    screen = DefaultScreen ( dpy );
    root = RootWindow ( dpy, screen );
    depth = DefaultDepth ( dpy, screen );
    XGetWindowAttributes ( dpy, root, &att );
    trombines_box.width = 450;
    trombines_box.height = 300;
    if ((depth != 8)&&(depth != 16)&&(depth != 24))
      trombines_box.height = 200;

    visual_tmpl.screen = screen;
    visual_tmpl.depth = depth;
    visual_list = XGetVisualInfo(dpy,VisualScreenMask|VisualDepthMask,
				 &visual_tmpl, &visual_matched);
    if (visual_matched == 0){
      trombines_box.height = 200;
      no_image = True;
    }

    trombines_box.t_height = trombines_box.font -> ascent + trombines_box.font -> descent + TB_SPACE;
    trombines_box.b_width = XTextWidth ( trombines_box.font, "Ok", 2 ) + (2 * TB_SPACE);
    trombines_box.b_height = trombines_box.t_height;
    
    trombines_box.str_x = (trombines_box.b_width - (trombines_box.b_width - (2 * TB_SPACE))) /2 ;
    trombines_box.str_y = trombines_box.font -> ascent + (TB_SPACE / 2);
    (void) strcpy ( trombines_box.title_text, " " );

    trombines_box.frame = XCreateSimpleWindow ( dpy, root, ((att.width/2) - (trombines_box.width/2)),
					  ((att.height/2) - (trombines_box.height/2)),  
				       trombines_box.width, trombines_box.height, 0, black, black );
    trombines_box.title = XCreateSimpleWindow ( dpy, trombines_box.frame, 0, 0,
					  10, 10,0, trombines_box.fg, trombines_box.bg);
    trombines_box.main = XCreateSimpleWindow ( dpy, trombines_box.frame, 0, trombines_box.t_height,
					 10, 10 ,0, trombines_box.fg, trombines_box.bg);
    trombines_box.ctr = XCreateSimpleWindow ( dpy, trombines_box.frame, 0, 0,
					10,trombines_box.t_height + (2 * TB_SPACE),0, trombines_box.fg, trombines_box.bg);
    trombines_box.ok = XCreateSimpleWindow ( dpy, trombines_box.ctr, 0, 0,
				       trombines_box.b_width, trombines_box.b_height,0, trombines_box.fg, trombines_box.bg);
    
    sizehints.flags = PPosition | USPosition | PSize | PMinSize | PMaxSize;
    sizehints.height = trombines_box.height;
    sizehints.width = trombines_box.width;
    sizehints.min_height = trombines_box.height;
    sizehints.min_width = trombines_box.width;
    sizehints.max_height = trombines_box.height;
    sizehints.max_width = trombines_box.width;
    sizehints.x = ((att.width/2) - (trombines_box.width/2));
    sizehints.y = ((att.height/2) - (trombines_box.height/2));
   
    XSelectInput ( dpy, trombines_box.frame, StructureNotifyMask );
    XSelectInput ( dpy, trombines_box.title, ExposureMask );
    XSelectInput ( dpy, trombines_box.main, ExposureMask );
    XSelectInput ( dpy, trombines_box.ctr, ExposureMask );
    XSelectInput ( dpy, trombines_box.ok, ExposureMask | ButtonPressMask );
    
    trombines_box.stat = TB_UNMAP;
    
    XStoreName ( dpy, trombines_box.frame, "Xcoral team" );

    if (((depth != 8)&&(depth != 16)&&(depth != 24))||no_image)
      return;

    if (depth>8) {
      image [0] = LoadImage256(bp_256);
      image [1] = LoadImage256(lf_256);
      image [2] = LoadImage256(dl_256);
    }
    else {
      image [0] = LoadImage16(bp_16gray);
      image [1] = LoadImage16(lf_16gray);
      image [2] = LoadImage16(dl_16gray);
    }
    
    if (no_image==True) {
      trombines_box.height = 200;
      sizehints.min_height = trombines_box.height;
    }
    XSetWMProperties ( dpy, trombines_box.frame, 0, 0, 0, 0, &sizehints, 0, 0 );
    trombines_del = XInternAtom( dpy, "WM_DELETE_WINDOW", False);
    (void) XSetWMProtocols ( dpy, trombines_box.frame, &trombines_del, 1);
}

int getDepth(unsigned long xx, int *max_value)
{
  unsigned long mask = xx; 
  int i,j;

  for(i=1;i<32;i++){
    if ((mask & 1)==1) {
      *max_value = mask+1;
      for(i=1;i<16;i++){
	mask = mask >> 1;
	if(mask==0)
	  break;
      }
      break;
    }
    mask = mask >> 1;
  }
  return i;
}

XImage * LoadImage16(char **xpm)
{
  /* Pour les Sun et autres engins a 8 plans !!! */
  int wp, hp, ncp, ncpp; /* infos pixmap */
  unsigned char *p;
  int i, j, index, dd;
  char c1,c2,c3;
  unsigned char rr, gg, bb;
  XColor xcolor;
  rgb cm[1024];
  rgb cm2[512];
  rgb cm3[128];
  XImage *image;
  int depth;
  unsigned char *data;
  int bytes_per_pixel;
  
  depth = DefaultDepth (dpy, DefaultScreen (dpy));
  bytes_per_pixel=1;
  if(depth==16)
    bytes_per_pixel=2;
  if(depth==24)
    bytes_per_pixel=3;
  
  sscanf (xpm[0],"%d %d %d %d", &wp, &hp, &ncp, &ncpp);  
  for (i=0;i<512;i++)cm[i].x = 0;
  for (i=1;i<(ncp+1);i++){ /* de 1 a 16*/
    c1 = (char) ((char *)xpm[i])[0];
    index = ((c1-7) * (c1-3)) % 507;
    if(cm[index].x == 0) {
      cm[index].x = 1;
      strncpy (cm[index].rrggbb,(char *)(xpm[i]+5),6);
      cm[index].c1 = c1;
      sscanf(((char *)(cm[index].rrggbb)),"%2X", &dd);
      xcolor.red = (unsigned short)dd<<8;
      xcolor.green = (unsigned short)dd<<8;
      xcolor.blue = (unsigned short)dd<<8;
      xcolor.flags = DoRed | DoGreen | DoBlue;
      if (XAllocColor(dpy,DefaultColormap(dpy,DefaultScreen(dpy)),&xcolor)==0) {
	no_image=True;
      }
      else
	cm[index].c2 = xcolor.pixel;
    }
    else {
      no_image=True;
    }
  }
  
  data = (char *) malloc (( wp * hp * bytes_per_pixel )+2);
  p = data;
  for(i=0;i<hp;i++){
    for(j=0;j<wp;j++){
      c1 = (char) (((char *)xpm[ncp+1+i])[j]);
      index = ((c1-7) * (c1-3)) % 507;
      if(cm[index].c1 == c1){
	/* C'est la bonne couleur */
	*p++ = (unsigned char)cm[index].c2 ;
      }
      else {
	printf("ca craint\n");
      }
    }
  }
  
  /* Ouf on a l'image */
  image = XCreateImage(dpy, 
		       DefaultVisual(dpy,DefaultScreen(dpy)),
		       DefaultDepth(dpy,DefaultScreen(dpy)),
		       ZPixmap,
		       0,
		       data,
		       wp, hp, 32,
		       wp * bytes_per_pixel);
  image->bits_per_pixel = DefaultDepth(dpy,DefaultScreen(dpy));
  return image;
}

XImage * LoadImage256(char **xpm)
{
    int wp, hp, ncp, ncpp; /* infos pixmap */
    char c1,c2,c3;
    unsigned char rr, gg, bb;
    unsigned char *p;
    int i, j, index, dd;
    char buf[2];
    XColor xcolor;
    rgb cm[1024];
    rgb cm2[512];
    rgb cm3[128];
    rgb cm4[256];
    XImage * image;
    int depth;
    unsigned char *data;
    int bytes_per_pixel;

    depth = DefaultDepth (dpy, DefaultScreen (dpy));
    bytes_per_pixel=1;
    if(depth==16)
      bytes_per_pixel=2;
    if(depth==24)
      bytes_per_pixel=3;
  
  sscanf (xpm[0],"%d %d %d %d", &wp, &hp, &ncp, &ncpp);
  
  for (i=0;i<1024;i++)cm[i].x = 0;      
  for (i=0;i<512;i++)cm2[i].x = 0;      
  for (i=0;i<128;i++)cm3[i].x = 0;      
  for (i=0;i<256;i++)cm4[i].x = 0;      
  for (i=1;i<(ncp+1);i++){
    rr = gg = bb = dd = 0;
    c1 = (char) ((char *)xpm[i])[0];
    c2 = (char) ((char *)xpm[i])[1];
    index = ((c1-7) * (c2-3)) % 1007;
    if(cm[index].x == 0) {
      cm[index].x = 1;
      if (((char)((char *)xpm[i])[5])=='N'){ /* (None. Pas de couleur */
	rr=gg=bb=0;
      }
      else {
	strncpy (cm[index].rrggbb,(char *)(xpm[i]+6),6);
	sscanf(((char *)(cm[index].rrggbb)),"%2X", &dd);
	rr = (unsigned char) dd;
	sscanf(((char *)(cm[index].rrggbb)+2),"%2X", &dd);
	gg = (unsigned char) dd;
	sscanf(((char *)(cm[index].rrggbb)+4),"%2X", &dd);
	bb = (unsigned char) dd;
      }
      xcolor.red = (unsigned short)(rr<<8);
      xcolor.green = (unsigned short)(gg<<8);
      xcolor.blue = (unsigned short)(bb<<8);
      xcolor.flags = DoRed | DoGreen | DoBlue;
      if (XAllocColor(dpy,DefaultColormap(dpy,DefaultScreen(dpy)),&xcolor)==0)
	printf("can't alloc color\n");

      cm[index].pixel = xcolor.pixel;
      cm[index].rrggbb[6]='\0';
      cm[index].c1 = c1;
      cm[index].c2 = c2;
    }
    else {
      index = ((c1-7) * (c2-3)) % 507;
      if(cm2[index].x == 0) {
	cm2[index].x = 1;
	strncpy (cm2[index].rrggbb,(char *)(xpm[i]+6),6);
	sscanf(((char *)(cm2[index].rrggbb)),"%2X", &dd);
	rr = (unsigned char) dd;
	sscanf(((char *)(cm2[index].rrggbb)+2),"%2X", &dd);
	gg = (unsigned char) dd;
	sscanf(((char *)(cm2[index].rrggbb)+4),"%2X", &dd);
	bb = (unsigned char) dd;
	xcolor.red = (unsigned short) (rr<<8);
	xcolor.green = (unsigned short) (gg<<8);
	xcolor.blue = (unsigned short) (bb<<8);
	xcolor.flags = DoRed | DoGreen | DoBlue;
	if (XAllocColor(dpy,DefaultColormap(dpy,DefaultScreen(dpy)),&xcolor)==0)
	  printf("can't alloc color\n");
	cm2[index].pixel = xcolor.pixel;
	cm2[index].rrggbb[6]='\0';
	cm2[index].c1 = c1;
	cm2[index].c2 = c2;
      }
      else {
	index = ((c1-7) * (c2-3)) % 119;
	if(cm3[index].x == 0) {
	  cm3[index].x = 1;
	  strncpy (cm3[index].rrggbb,(char *)(xpm[i]+6),6);
	  sscanf(((char *)(cm3[index].rrggbb)),"%2X", &dd);
	  rr = (unsigned char) dd;
	  sscanf(((char *)(cm3[index].rrggbb)+2),"%2X", &dd);
	  gg = (unsigned char) dd;
	  sscanf(((char *)(cm3[index].rrggbb)+4),"%2X", &dd);
	  bb = (unsigned char) dd;
	  xcolor.red = (unsigned short) (rr<<8);
	  xcolor.green = (unsigned short) (gg<<8);
	  xcolor.blue = (unsigned short) (bb<<8);
	  xcolor.flags = DoRed | DoGreen | DoBlue;
	  if (XAllocColor(dpy,DefaultColormap(dpy,DefaultScreen(dpy)),&xcolor)==0)
	    printf("can't alloc color\n");
	  cm3[index].pixel = xcolor.pixel;
 	  cm3[index].rrggbb[6]='\0';
	  cm3[index].c1 = c1;
	  cm3[index].c2 = c2;
	}
	else {
	  index = ((c1-7) * (c2-3)) % 201;
	  if(cm4[index].x == 0) {
	    cm4[index].x = 1;
	    strncpy (cm4[index].rrggbb,(char *)(xpm[i]+6),6);
	    sscanf(((char *)(cm4[index].rrggbb)),"%2X", &dd);
	    rr = (unsigned char) dd;
	    sscanf(((char *)(cm4[index].rrggbb)+2),"%2X", &dd);
	    gg = (unsigned char) dd;
	    sscanf(((char *)(cm4[index].rrggbb)+4),"%2X", &dd);
	    bb = (unsigned char) dd;
	    xcolor.red = (unsigned short) (rr<<8);
	    xcolor.green = (unsigned short) (gg<<8);
	    xcolor.blue = (unsigned short) (bb<<8);
	    xcolor.flags = DoRed | DoGreen | DoBlue;
	    if (XAllocColor(dpy,DefaultColormap(dpy,DefaultScreen(dpy)),&xcolor)==0)
	      printf("can't alloc color\n");
	    cm4[index].pixel = xcolor.pixel;
	    cm4[index].rrggbb[6]='\0';
	    cm4[index].c1 = c1;
	    cm4[index].c2 = c2;
	  }
	  else
	    printf("brrr index = %d c1 = %d c2 = %d %s\n", index, c1, c2, cm[index].rrggbb);
	  }
      }
    }
  }
  
  /* La table des couleurs est OK */
  /* 1er ligne du pixmap: xpm[ncp+1] */
  data = (char *) malloc (( wp * hp * bytes_per_pixel )+2);
  p = data;
  for(i=0;i<hp;i++){
    for(j=0;j<wp;j++){
      c1 = (char) (((char *)xpm[ncp+1+i])[(2*j)]);
      c2 = (char) (((char *)xpm[ncp+1+i])[(2*j)+1]);
      index = ((c1-7) * (c2-3)) % 1007;
      if((cm[index].c1 == c1) && (cm[index].c2 == c2)) {
	*p++ = (unsigned char)cm[index].pixel;
	*p++ = (unsigned char) (cm[index].pixel>>8);
	if (bytes_per_pixel==3)
	  *p++ = (unsigned char) (cm[index].pixel>>16);
      }
      else {
	index = ((c1-7) * (c2-3)) % 507;
	if((cm2[index].c1 == c1) && (cm2[index].c2 == c2)){
	  *p++ = (unsigned char)cm2[index].pixel;
	  *p++ = (unsigned char) (cm2[index].pixel>>8);
	  if (bytes_per_pixel==3)
	    *p++ = (unsigned char) (cm2[index].pixel>>16);
	}
	else {
	  index = ((c1-7) * (c2-3)) % 119;
	  if((cm3[index].c1 == c1) && (cm3[index].c2 == c2)){
	    *p++ = (unsigned char)cm3[index].pixel;
	    *p++ = (unsigned char) (cm3[index].pixel>>8);
	    if (bytes_per_pixel==3)
	      *p++ = (unsigned char) (cm3[index].pixel>>16);
	  }
	  else {
	    index = ((c1-7) * (c2-3)) % 201;
	    *p++ = (unsigned char)cm4[index].pixel;
	    *p++ = (unsigned char) (cm4[index].pixel>>8);
	    if (bytes_per_pixel==3)
	      *p++ = (unsigned char) (cm4[index].pixel>>16);
	  }
	}
      }
    }
  }
  
  /* Ouf on a l'image */
  image = XCreateImage(dpy, 
			  DefaultVisual(dpy,DefaultScreen(dpy)),
			  DefaultDepth(dpy,DefaultScreen(dpy)),
			  ZPixmap,
			  0,
			  data,
			  wp, hp, 32,
			  wp * bytes_per_pixel);
  image->bits_per_pixel = DefaultDepth(dpy,DefaultScreen(dpy));
  return image;
}

/*
**	Function name : DisplayTrombines
**
**	Description :
**	Input :
**	Output :
*/
void DisplayTrombines()
{
    int by, bx;

    if ( trombines_box.stat != TB_MAP ) {
      XMapSubwindows ( dpy, trombines_box.frame );
      XMapSubwindows ( dpy, trombines_box.main );    
      XMapSubwindows ( dpy, trombines_box.ctr );
      XMapRaised ( dpy, trombines_box.frame ); 
      WaitForMapped ( trombines_box.frame, False );
      trombines_box.stat = TB_MAP;	
    }
    else
          XMapRaised ( dpy, trombines_box.frame );

    by = ((trombines_box.t_height + (2 * TB_SPACE) - trombines_box.b_height)) / 2;
    bx = ((trombines_box.width / 2) - trombines_box.b_width) / 2;

    UpdateTrombinesTitle ();
    FreezeMenus ();
}

void ConfigTrombinesBox ( width, height )
    int width, height;
{
    int m_height, bx, by;
    static int db_first_conf = True;

    if ( (width == trombines_box.width) 
	&& (height == trombines_box.height) 
	&& (db_first_conf == False )) {
	return;
    }
    else
	db_first_conf = False;
    
    trombines_box.width = width;
    trombines_box.height = height;

    m_height = trombines_box.height - ((2 * trombines_box.t_height) + ( 2 * TB_SPACE));
    bx = ((width / 2) - (trombines_box.b_width/2));
    by = ((trombines_box.t_height + (2 * TB_SPACE) - trombines_box.b_height)) / 2;
    
    XResizeWindow ( dpy, trombines_box.frame, trombines_box.width, trombines_box.height );
    XResizeWindow ( dpy, trombines_box.title, trombines_box.width, trombines_box.t_height );
    XResizeWindow ( dpy, trombines_box.ctr, trombines_box.width, trombines_box.t_height + (2 * TB_SPACE));
    XResizeWindow ( dpy, trombines_box.main, trombines_box.width, m_height  );
    XMoveWindow ( dpy, trombines_box.ctr, 0, trombines_box.t_height + m_height );
    XMoveWindow ( dpy, trombines_box.ok, bx, by );
}

int ExposeTrombinesBox ( ev )
    XEvent *ev;
{
#define lf_add "Lionel Fournigault"
#define bp_add "Bruno Pages"
#define dl_add "Dominique Leveque"
  
    int x, ih;
    char xc_version [64];
    int depth = DefaultDepth(dpy,DefaultScreen(dpy));
    
    if ( (ev -> xexpose.window == trombines_box.main) 
	|| (ev -> xexpose.window == trombines_box.ctr)) {
	Display3D ( dpy, ev -> xexpose.window, trombines_box.ts, trombines_box.bs, 1, 0 );
	ih = 0;
	if (((depth == 8)||(depth == 16)||(depth == 24)) && (no_image==False)) {
	    XPutImage (dpy, trombines_box.main, trombines_box.gc, image[0], 0, 0, 30, 10, 110, 150);
	    XPutImage (dpy, trombines_box.main, trombines_box.gc, image[1], 0, 0, 170, 10, 110, 150);
	    XPutImage (dpy, trombines_box.main, trombines_box.gc, image[2], 0, 0, 310, 10, 110, 150);
	}
	else
	  ih = 140;
	XDrawString ( dpy, trombines_box.main, trombines_box.gc,
		     30 + (110 - XTextWidth(trombines_box.font,bp_add,strlen(bp_add)))/2,
		     150 - ih + 25 ,bp_add , strlen(bp_add)); 
	XDrawString ( dpy, trombines_box.main, trombines_box.gc,
		     170 + (110 - XTextWidth(trombines_box.font,lf_add,strlen(lf_add)))/2,
		     150 - ih + 25 ,lf_add , strlen(lf_add)); 
	XDrawString ( dpy, trombines_box.main, trombines_box.gc,
		     310+ (110 - XTextWidth(trombines_box.font,dl_add,strlen(dl_add)))/2,
		     150 - ih + 25 ,dl_add , strlen(dl_add));

	sprintf (xc_version,"Xcoral release %s", CURRENT_VERSION);
	XDrawString ( dpy, trombines_box.main, trombines_box.gc,
		     30,200 - ih ,xc_version, strlen(xc_version));
	XDrawString ( dpy, trombines_box.main, trombines_box.gc,
		     30,212 - ih ,"e-mail: xcoral@free.fr",
		     strlen("e-mail: xcoral@free.fr"));
	XDrawString ( dpy, trombines_box.main, trombines_box.gc,
		     30,224 - ih ,"home: http://xcoral.free.fr",
		     strlen("home: http://xcoral.free.fr"));
	return True;
    }
    if ( ev -> xexpose.window == trombines_box.title ) {
      UpdateTrombinesTitle ();
      return True;
    }
	
    if ( ev -> xexpose.window == trombines_box.ok ) {
	x = (trombines_box.b_width - XTextWidth ( trombines_box.font, "Ok", 2)) / 2;
	XDrawString ( dpy, trombines_box.ok, trombines_box.gc, x, trombines_box.str_y, "Ok", 2);
	Display3D ( dpy, ev -> xexpose.window, trombines_box.ts, trombines_box.bs, 1, 0 );
	return True;
    }
    return False;
}

/*
**	Function name : ButtonTrombinesBox
**
**	Description : 
**	Input : 
**	Ouput :
*/
int ButtonTrombinesBox ( ev )
    XButtonEvent *ev;
{
    if ( ev -> window == trombines_box.ok) {
        Display3D ( dpy, trombines_box.ok, trombines_box.ts, trombines_box.bs, 1, 1 );
	if ( trombines_box.stat != TB_UNMAP ) {
	  XUnmapWindow ( dpy, trombines_box.frame );
	  trombines_box.stat = TB_UNMAP;
	}
	UnFreezeMenus ();
	return True;
    }
    return False;
}

static void UpdateTrombinesTitle ()
{
  XClearWindow ( dpy, trombines_box.title );
  XDrawString ( dpy, trombines_box.title, trombines_box.gc,
	       (trombines_box.width - XTextWidth( trombines_box.font,"Xcoral Team",
						 strlen("Xcoral Team")))/2,
	       trombines_box.str_y, "Xcoral Team", strlen("Xcoral Team"));
  Display3D ( dpy, trombines_box.title, trombines_box.ts, trombines_box.bs, 1, 0 );
}
