/* Dali Clock - a melting digital clock for PalmOS.
 * Copyright (c) 1991-2007 Jamie Zawinski <jwz@jwz.org>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "numbers.h"

# include "zero0.xbm"
# include "one0.xbm"
# include "two0.xbm"
# include "three0.xbm"
# include "four0.xbm"
# include "five0.xbm"
# include "six0.xbm"
# include "seven0.xbm"
# include "eight0.xbm"
# include "nine0.xbm"
# include "colon0.xbm"
# include "slash0.xbm"

static struct raw_number numbers_0 [] = {
  { zero0_bits, zero0_width, zero0_height },
  { one0_bits, one0_width, one0_height },
  { two0_bits, two0_width, two0_height },
  { three0_bits, three0_width, three0_height },
  { four0_bits, four0_width, four0_height },
  { five0_bits, five0_width, five0_height },
  { six0_bits, six0_width, six0_height },
  { seven0_bits, seven0_width, seven0_height },
  { eight0_bits, eight0_width, eight0_height },
  { nine0_bits, nine0_width, nine0_height },
  { colon0_bits, colon0_width, colon0_height },
  { slash0_bits, slash0_width, slash0_height },
  { 0, 0, 0 }
};


# include "zeroD2.xbm"
# include "oneD2.xbm"
# include "twoD2.xbm"
# include "threeD2.xbm"
# include "fourD2.xbm"
# include "fiveD2.xbm"
# include "sixD2.xbm"
# include "sevenD2.xbm"
# include "eightD2.xbm"
# include "nineD2.xbm"
# include "colonD2.xbm"
# include "slashD2.xbm"

static struct raw_number numbers_D2 [] = {
  { zeroD2_bits,  zeroD2_width,  zeroD2_height  },
  { oneD2_bits,   oneD2_width,   oneD2_height   },
  { twoD2_bits,   twoD2_width,   twoD2_height   },
  { threeD2_bits, threeD2_width, threeD2_height },
  { fourD2_bits,  fourD2_width,  fourD2_height  },
  { fiveD2_bits,  fiveD2_width,  fiveD2_height  },
  { sixD2_bits,   sixD2_width,   sixD2_height   },
  { sevenD2_bits, sevenD2_width, sevenD2_height },
  { eightD2_bits, eightD2_width, eightD2_height },
  { nineD2_bits,  nineD2_width,  nineD2_height  },
  { colonD2_bits, colonD2_width, colonD2_height },
  { slashD2_bits, slashD2_width, slashD2_height },
  { 0, }
};

#if 0
# include "zeroD.xbm"
# include "oneD.xbm"
# include "twoD.xbm"
# include "threeD.xbm"
# include "fourD.xbm"
# include "fiveD.xbm"
# include "sixD.xbm"
# include "sevenD.xbm"
# include "eightD.xbm"
# include "nineD.xbm"
# include "colonD.xbm"
# include "slashD.xbm"

struct raw_number numbers_D [] = {
  { zeroD_bits,  zeroD_width,  zeroD_height  },
  { oneD_bits,   oneD_width,   oneD_height   },
  { twoD_bits,   twoD_width,   twoD_height   },
  { threeD_bits, threeD_width, threeD_height },
  { fourD_bits,  fourD_width,  fourD_height  },
  { fiveD_bits,  fiveD_width,  fiveD_height  },
  { sixD_bits,   sixD_width,   sixD_height   },
  { sevenD_bits, sevenD_width, sevenD_height },
  { eightD_bits, eightD_width, eightD_height },
  { nineD_bits,  nineD_width,  nineD_height  },
  { colonD_bits, colonD_width, colonD_height },
  { slashD_bits, slashD_width, slashD_height },
  { 0, }
};
#endif

# include "zeroE.xbm"
# include "oneE.xbm"
# include "twoE.xbm"
# include "threeE.xbm"
# include "fourE.xbm"
# include "fiveE.xbm"
# include "sixE.xbm"
# include "sevenE.xbm"
# include "eightE.xbm"
# include "nineE.xbm"
# include "colonE.xbm"
# include "slashE.xbm"

struct raw_number numbers_E [] = {
  { zeroE_bits,  zeroE_width,  zeroE_height  },
  { oneE_bits,   oneE_width,   oneE_height   },
  { twoE_bits,   twoE_width,   twoE_height   },
  { threeE_bits, threeE_width, threeE_height },
  { fourE_bits,  fourE_width,  fourE_height  },
  { fiveE_bits,  fiveE_width,  fiveE_height  },
  { sixE_bits,   sixE_width,   sixE_height   },
  { sevenE_bits, sevenE_width, sevenE_height },
  { eightE_bits, eightE_width, eightE_height },
  { nineE_bits,  nineE_width,  nineE_height  },
  { colonE_bits, colonE_width, colonE_height },
  { slashE_bits, slashE_width, slashE_height },
  { 0, }
};

struct raw_number *get_raw_number_0 (void) { return numbers_0; }  /* 27  */
struct raw_number *get_raw_number_1 (void) { return numbers_D2; } /* 116 */
struct raw_number *get_raw_number_2 (void) { return numbers_E; }  /* 65  */
struct raw_number *get_raw_number_3 (void) { return numbers_D2; } /* 116 */

/* I'd like to use numbers_D (128) for get_raw_number_3, but it makes the
   data segment too large "Signed .word overflow; switch may be too large")
 */
