/*
 * xdemineur 1.1 - X11 minefield game
 *
 * Author: Marc Baudoin (baudoin@ensta.fr)
 *
 *            |\
 *          |\| \
 *          |//  )
 *        |\ /  /        /\/\_
 *        |//  /        /. . /
 *      |\ /  /     ___/    |_
 *      |//  /     (____/    /_/\_
 *       |__|      (_____/ __     >
 *     /| ___  ________ _< \ \__  >
 *     \|| __\| _|_   _/ \\ \___\/
 *       | __\____ | |/ _ \\    >
 *     /||___\_____|___/ \_\\  _>
 *     \|____           ____ \|
 *       \   \_________/   /
 *        \   _    _      /
 *         \_//   //_____/
 *           (_   \ (_  _\
 *             |/\|   \/
 *
 * Ecole Nationale Superieure de Techniques Avancees (ENSTA)
 * 32, boulevard Victor - 75015 Paris - France
 *
 * Copyright (C) 1993 Marc Baudoin
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.  The author makes no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 */



#include <stdlib.h>
#include <sys/time.h>
/*#include <sys/types.h> sur certains systemes pour definir time_t */
#include "demineur.h"

struct jeu **tableau ;   /* le tableau de jeu */

int nb_lig = NB_LIG ;    /* nombre de lignes   du tableau de jeu */
int nb_col = NB_COL ;    /* nombre de colonnes du tableau de jeu */
int nb_mines ;           /* nombre de mines    du tableau de jeu */

int mines ;              /* nombre de mines restant a trouver */

time_t temps ;           /* nombre de secondes ecoulees depuis le debut du jeu */

BOOLEAN perdu , gagne , jeu , ouvre = FALSE ;

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ Gestion du jeu ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */

remplis_et_compte ( )
{
   register int l , c , i ;

   /* initialisation des variables */

   mines = nb_mines ;
   temps = 0L ;
   perdu = gagne = jeu = FALSE ;

   /* initialisation du tableau */

   for ( l = 0 ; l < nb_lig + 2 ; l ++ )
   {
      for ( c = 0 ; c < nb_col + 2 ; c ++ )
      {
         tableau [ l ] [ c ] . mine   = FALSE ;
         tableau [ l ] [ c ] . nombre = 0 ;
         tableau [ l ] [ c ] . etat   = COUVERTE ;
      }
   }

   /* pose des mines */

#ifdef USE_RAND48
   srand48 ( time ( 0 ) ) ;
#endif

#ifdef USE_RANDOM
   srandom ( time ( 0 ) ) ;
#endif

#ifdef USE_RAND
   srand ( time ( 0 ) ) ;
#endif

   i = nb_mines ;
   while ( i > 0 )
   {
#ifdef USE_RAND48
      l = 1 + ( int ) ( lrand48 ( ) % nb_lig ) ;
      c = 1 + ( int ) ( lrand48 ( ) % nb_col ) ;
#endif
#ifdef USE_RANDOM
      l = 1 + ( int ) ( random ( ) % nb_lig ) ;
      c = 1 + ( int ) ( random ( ) % nb_col ) ;
#endif
#ifdef USE_RAND
      l = 1 + ( int ) ( rand ( ) % nb_lig ) ;
      c = 1 + ( int ) ( rand ( ) % nb_col ) ;
#endif
      if ( ! tableau [ l ] [ c ] . mine )
      {
         tableau [ l ] [ c ] . mine = TRUE ;
         i -- ;
      }
   }

   /* comptage des mines */

   for ( l = 1 ; l <= nb_lig ; l ++ )
   {
      for ( c = 1 ; c <= nb_col ; c ++ )
      {
         tableau [ l ] [ c ] . nombre = mine01 ( l - 1 , c - 1 ) +
                                        mine01 ( l - 1 , c     ) +
                                        mine01 ( l - 1 , c + 1 ) +
                                        mine01 ( l     , c - 1 ) +
                                        mine01 ( l     , c + 1 ) +
                                        mine01 ( l + 1 , c - 1 ) +
                                        mine01 ( l + 1 , c     ) +
                                        mine01 ( l + 1 , c + 1 ) ;
      }
   }

   /* ouverture automatique */

   while ( ouvre )
   {
#ifdef USE_RAND48
      l = 1 + ( int ) ( lrand48 ( ) % nb_lig ) ;
      c = 1 + ( int ) ( lrand48 ( ) % nb_col ) ;
#endif
#ifdef USE_RANDOM
      l = 1 + ( int ) ( random ( ) % nb_lig ) ;
      c = 1 + ( int ) ( random ( ) % nb_col ) ;
#endif
#ifdef USE_RAND
      l = 1 + ( int ) ( rand ( ) % nb_lig ) ;
      c = 1 + ( int ) ( rand ( ) % nb_col ) ;
#endif
      if ( tableau [ l ] [ c ] . nombre == 0 &&
           ! tableau [ l ] [ c ] . mine )
      {
         decouvre ( l , c ) ;
         break ;
      }
   }
}

int mine01 ( lig , col )
int lig , col ;
{
   return ( tableau [ lig ] [ col ] . mine ? 1 : 0 ) ;
}

joue ( lig , col )
int lig , col ;
{
   if ( tableau [ lig ] [ col ] . mine )   /* perdu ! */
   {
      perdu = TRUE ;
      jeu = FALSE ;
      tableau [ lig ] [ col ] . etat = DECOUVERTE ;
      affiche_jeu ( ) ;
   }
   else if ( tableau [ lig ] [ col ] . nombre == 0 )
   {
      decouvre ( lig , col ) ;
   }
   else
   {
      tableau [ lig ] [ col ] . etat = DECOUVERTE ;
      affiche_case ( lig , col ) ;
   }
   if ( mines == 0 )   /* gagne ? */
   {
      gagne_perdu ( ) ;
   }
}

decouvre ( lig , col )
int lig , col ;
{
   if ( lig >= 1 && lig <= nb_lig && col >= 1 && col <= nb_col )
   {
      if ( tableau [ lig ] [ col ] . etat != DECOUVERTE &&
           tableau [ lig ] [ col ] . etat != MARQUEE )
      {
         tableau [ lig ] [ col ] . etat = DECOUVERTE ;
         affiche_case ( lig , col ) ;
         if ( tableau [ lig ] [ col ] . mine )
         {
            perdu = TRUE ;
            jeu = FALSE ;
            affiche_jeu ( ) ;
         }
         if ( tableau [ lig ] [ col ] . nombre == 0 )
         {
            decouvre ( lig - 1 , col - 1 ) ;
            decouvre ( lig - 1 , col     ) ;
            decouvre ( lig - 1 , col + 1 ) ;
            decouvre ( lig     , col - 1 ) ;
            decouvre ( lig     , col + 1 ) ;
            decouvre ( lig + 1 , col - 1 ) ;
            decouvre ( lig + 1 , col     ) ;
            decouvre ( lig + 1 , col + 1 ) ;
         }
         if ( mines == 0 )   /* gagne ? */
         {
            gagne_perdu ( ) ;
         }
      }
   }
}

double_clic ( lig , col )
int lig , col ;
{
   decouvre ( lig - 1 , col - 1 ) ;
   decouvre ( lig - 1 , col     ) ;
   decouvre ( lig - 1 , col + 1 ) ;
   decouvre ( lig     , col - 1 ) ;
   decouvre ( lig     , col + 1 ) ;
   decouvre ( lig + 1 , col - 1 ) ;
   decouvre ( lig + 1 , col     ) ;
   decouvre ( lig + 1 , col + 1 ) ;
}

marque ( lig , col )
int lig , col ;
{
   switch ( tableau [ lig ] [ col ] . etat )
   {
   case COUVERTE :
      if ( mines > 0 )
      {
         tableau [ lig ] [ col ] . etat = MARQUEE ;
         mines -- ;
         nombre_de_mines ( ) ;
         affiche_case ( lig , col ) ;
         if ( mines == 0 )   /* gagne ? */
         {
               gagne_perdu ( ) ;
         }
      }
      break ;
   case MARQUEE :
      tableau [ lig ] [ col ] . etat = INTERRO ;
      mines ++ ;
      nombre_de_mines ( ) ;
      affiche_case ( lig , col ) ;
      break ;
   case INTERRO :
      tableau [ lig ] [ col ] . etat = COUVERTE ;
      affiche_case ( lig , col ) ;
      break ;
   }
}

gagne_perdu ( )
{
   register int l , c ;
   BOOLEAN ok = TRUE ;

   for ( l = 1 ; l <= nb_lig ; l ++ )
   {
      for ( c = 1 ; c <= nb_col ; c ++ )
      {
         if ( tableau [ l ] [ c ] . etat != DECOUVERTE &&
              tableau [ l ] [ c ] . etat != MARQUEE )
         {
            ok = FALSE ;
         }
      }
   }
   if ( ok )   /* gagne ! */
   {
      gagne = TRUE ;
      jeu = FALSE ;
      icone_perdu_gagne ( ) ;
   }
}
