.\" $XFree86: xc/programs/Xserver/hw/darwin/XDarwin.man,v 1.2 2001/05/21 01:42:16 torrey Exp $
.\"
.TH XDARWIN 1 __vendorversion__
.SH NAME
XDarwin \- X window system server for Darwin operating system
.SH SYNOPSIS
.B XDarwin
[ options ] ...
.SH DESCRIPTION
#ifdef DARWIN_WITH_QUARTZ
.I XDarwin
is the window server for Version 11 of the X window system on the Darwin
operating system.
.I XDarwin
can be started from the Darwin text console, or while running the Mac OS X
Aqua GUI.
.PP
When running from the console,
.I XDarwin
acts as the window server and uses IOKit services to accesss the display framebuffer,
mouse and keyboard and to provide a layer of hardware abstraction. In console mode,
.I XDarwin
will normally be started by the \fIxdm(1)\fP display manager or by a script
that runs the program \fIxinit(1)\fP.
.PP
When running with the Mac OS X Aqua GUI,
.I XDarwin
will normally be started by launching it from the Finder, but it may also be started from the command line with the \fB\-quartz\fP option. The
.I XDarwin
application allows easy switching between the Mac OS X and X window
desktops. CoreGraphics is used to capture and draw to the screen. Note that the defaults for various command line options are set by the application preferences in this mode.
#else
.I XDarwin
is the window server for Version 11 of the X window system on the Darwin
operating system. This version of
.I XDarwin
can only be started from the Darwin text console. The Mac OS X Aqua GUI, if present, must be shut down.
.I XDarwin
uses IOKit services to accesss the display
framebuffer, mouse and keyboard and to provide a layer of hardware abstraction.
.I XDarwin
will normally be started by the \fIxdm(1)\fP display manager or by a script
that runs the program \fIxinit(1)\fP.
#endif
.SH OPTIONS
.PP
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXDarwin\fP accepts the following command line switches:
.TP 8
.B \-fakebuttons
Emulates a 3 button mouse using the Command and Option keys. Clicking the
first mouse button while holding down Command will act like clicking
button 2. Holding down Option will simulate button 3.
.TP 8
.B \-nofakebuttons
Do not emulate a 3 button mouse. This is the default.
.TP 8
.B "\-keymap \fIfile\fP"
On startup \fIXDarwin\fP translates a Darwin keymapping into an X keymap. With this option the keymapping is read from a file instead of the kernel. If the file's path is not specified, it will be searched for in Library/Keyboards/ underneath the following directories (in order): ~, /, /Network, /System.
#ifdef DARWIN_WITH_QUARTZ
.TP 8
.B "\-size \fIwidth\fP \fIheight\fP"
Sets the screeen resolution for the X server to use.
This option is ignored if \fB\-quartz\fP is specified.
.TP 8
.B "\-depth \fIdepth\fP"
Specifies the color bit depth to use. Currently only 8, 15, and 24 color bits
per pixel are supported.
This option is ignored if \fB\-quartz\fP is specified.
.TP 8
.B "\-refresh \fIrate\fP"
Gives the refresh rate to use in Hz. For LCD displays this should be 0.
This option is ignored if \fB\-quartz\fP is specified.
.TP 8
.B "\-screen \fIscreenum\fP"
Specifies which screen number the X server should run on. Screen number 0 is the default. This option is ignored if \fB\-quartz\fP is specified.
.TP 8
.B \-quartz
Run in parallel with the Mac OS X Aqua GUI.
#else
.TP 8
.B "\-size \fIwidth\fP \fIheight\fP"
Sets the screeen resolution for the X server to use.
.TP 8
.B "\-depth \fIdepth\fP"
Specifies the color bit depth to use. Currently only 8, 15, and 24 color bits
per pixel are supported.
.TP 8
.B "\-refresh \fIrate\fP"
Gives the refresh rate to use in Hz. For LCD displays this should be 0.
.TP 8
.B "\-screen \fIscreenum\fP"
Specifies which screen number the X server should run on. Screen number 0 is the default.
#endif
.TP 8
.B \-showconfig
Print out the server version and patchlevel.
.TP 8
.B \-version
Same as \fB\-showconfig\fP.
.SH "SEE ALSO"
.PP
X(__miscmansuffix__), Xserver(1), xdm(1), xinit(1)
.SH BUGS
.I XDarwin
and this man page still have many limitations. Some of the more obvious
ones are:
.br
- There is no rootless mode with Aqua.
.br
- Only one display is supported.
.br
- The display mode can not be changed once the X server has started.
.br
- A screen saver is not supported.
.PP
.SH AUTHORS
XFree86 was originally ported to Mac OS X Server by John Carmack. Dave Zarzycki used this as the basis of his port of XFree86 4.0 to Darwin 1.0. Torrey T. Lyons improved and integrated this code into the XFree86 Project's mainline for the 4.0.2 release.
.PP
The following members of the XonX Team contributed to the XFree86 4.1 release:
.PP
Rob Braun - Darwin x86 support
.br
Torrey T. Lyons - Project Lead
.br
Andreas Monitzer - Cocoa version of XDarwin front end
.br
Gregory Robert Parker - Original Quartz implementation
.br
Christoph Pfisterer - Dynamic shared X libraries
.br
Toshimitsu Tanaka - Japanese localization
