/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2002 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * utils.h
 */

void savelog(GtkWidget *clist, gchar *logfile);
gchar *setlocation(gdouble lat, gint NS, gdouble lon, gint EW);
void updateoptionmenu(GtkWidget *optionmenu, gchar **split);
void deletespaces(gchar **split);
void update_statusbar(gchar *string);
gboolean remove_prefixes(gchar *key, gpointer value, gpointer user_data);
gboolean latexavailable(void);
void save_windowsize_and_cleanup(void);
gchar *finddot(gchar *qsoband);
gchar *getdate(void);
gchar *gettime(void);
gchar *lookup_mode(gchar *selectedmode);
gchar *lookup_band(gchar *selectedband);
gint updateclock(void);
gchar *color_parse(gchar *value);
void setcallstyle(GtkWidget *clist, gint row, gchar *color);
gchar *getlabelcolor(GtkWidget *label);
void setlabelstyle(GtkWidget *label, gchar *color);
void setframestyle(GtkWidget *frame, gchar *color);
gint autosave(void);
