/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __LIST_ID3FRAMES_H__
#define __LIST_ID3FRAMES_H__

#include <id3.h>
#include "singit/macros.h"

typedef struct {

	char *frameName;
	ID3_FrameID frameID;
	char *frameLongName;
}
id3frame_list_entry;

#define list_id3frames_count 75
static id3frame_list_entry list_id3frames[] = {

	{ "????", ID3FID_NOFRAME,           N_("No known frame") },
	{ "AENC", ID3FID_AUDIOCRYPTO,  	    N_("Audio encryption") },
	{ "APIC", ID3FID_PICTURE,           N_("Attached picture") },
	{ "COMM", ID3FID_COMMENT,           N_("Comments") },
	{ "COMR", ID3FID_COMMERCIAL,        N_("Commercial frame") },
	{ "ENCR", ID3FID_CRYPTOREG,         N_("Encryption method registration") },
	{ "EQUA", ID3FID_EQUALIZATION, 	    N_("Equalization") },
	{ "ETCO", ID3FID_EVENTTIMING, 	    N_("Event timing codes") },
	{ "GEOB", ID3FID_GENERALOBJECT,	    N_("General encapsulated object") },
	{ "GRID", ID3FID_GROUPINGREG,       N_("Group identification registration") },
	{ "IPLS", ID3FID_INVOLVEDPEOPLE,    N_("Involved people list") },
	{ "LINK", ID3FID_LINKEDINFO,        N_("Linked information") },
	{ "MCDI", ID3FID_CDID,              N_("Music CD identifier") },
	{ "MLLT", ID3FID_MPEGLOOKUP,        N_("MPEG location lookup table") },
	{ "OWNE", ID3FID_OWNERSHIP,         N_("Ownership frame") },
	{ "PRIV", ID3FID_PRIVATE,           N_("Private frame") },
	{ "PCNT", ID3FID_PLAYCOUNTER,       N_("Play counter") },
	{ "POPM", ID3FID_POPULARIMETER,     N_("Popularimeter") },
	{ "POSS", ID3FID_POSITIONSYNC,      N_("Position synchronisation frame") },
	{ "RBUF", ID3FID_BUFFERSIZE,        N_("Recommended buffer size") },
	{ "RVAD", ID3FID_VOLUMEADJ,         N_("Relative volume adjustment") },
	{ "RVRB", ID3FID_REVERB,            N_("Reverb") },
	{ "SYLT", ID3FID_SYNCEDLYRICS,      N_("Synchronized lyric/text") },
	{ "SYTC", ID3FID_SYNCEDTEMPO,       N_("Synchronized tempo codes") },
	{ "TALB", ID3FID_ALBUM,             N_("Album/Movie/Show title") },
	{ "TBPM", ID3FID_BPM,               N_("BPM (beats per minute)") },
	{ "TCOM", ID3FID_COMPOSER,          N_("Composer") },
	{ "TCON", ID3FID_CONTENTTYPE,       N_("Content type") },
	{ "TCOP", ID3FID_COPYRIGHT,         N_("Copyright message") },
	{ "TDAT", ID3FID_DATE,              N_("Date") },
	{ "TDLY", ID3FID_PLAYLISTDELAY,     N_("Playlist delay") },
	{ "TENC", ID3FID_ENCODEDBY,         N_("Encoded by") },
	{ "TEXT", ID3FID_LYRICIST,          N_("Lyricist/Text writer") },
	{ "TFLT", ID3FID_FILETYPE,          N_("File type") },
	{ "TIME", ID3FID_TIME,              N_("Time") },
	{ "TIT1", ID3FID_CONTENTGROUP,      N_("Content group description") },
	{ "TIT2", ID3FID_TITLE,             N_("Title/songname/content description") },
	{ "TIT3", ID3FID_SUBTITLE,          N_("Subtitle/Description refinement") },
	{ "TKEY", ID3FID_INITIALKEY,        N_("Initial key") },
	{ "TLAN", ID3FID_LANGUAGE,          N_("Language(s)") },
	{ "TLEN", ID3FID_SONGLEN,           N_("Length") },
	{ "TMED", ID3FID_MEDIATYPE,         N_("Media type") },
	{ "TOAL", ID3FID_ORIGALBUM,         N_("Original album/movie/show title") },
	{ "TOFN", ID3FID_ORIGFILENAME,      N_("Original filename") },
	{ "TOLY", ID3FID_ORIGLYRICIST,      N_("Original lyricist(s)/text writer(s)") },
	{ "TOPE", ID3FID_ORIGARTIST,        N_("Original artist(s)/performer(s)") },
	{ "TORY", ID3FID_ORIGYEAR,          N_("Original release year") },
	{ "TOWN", ID3FID_FILEOWNER,         N_("File owner/licensee") },
	{ "TPE1", ID3FID_LEADARTIST,        N_("Lead performer(s)/Soloist(s)") },
	{ "TPE2", ID3FID_BAND,              N_("Band/orchestra/accompaniment") },
	{ "TPE3", ID3FID_CONDUCTOR,         N_("Conductor/performer refinement") },
	{ "TPE4", ID3FID_MIXARTIST,         N_("Interpreted, remixed, or otherwise modified by") },
	{ "TPOS", ID3FID_PARTINSET,         N_("Part of a set") },
	{ "TPUB", ID3FID_PUBLISHER,         N_("Publisher") },
	{ "TRCK", ID3FID_TRACKNUM,          N_("Track number/Position in set") },
	{ "TRDA", ID3FID_RECORDINGDATES,    N_("Recording dates") },
	{ "TRSN", ID3FID_NETRADIOSTATION,   N_("Internet radio station name") },
	{ "TRSO", ID3FID_NETRADIOOWNER,     N_("Internet radio station owner") },
	{ "TSIZ", ID3FID_SIZE,              N_("Size") },
	{ "TSRC", ID3FID_ISRC,              N_("ISRC (international standard recording code)") },
	{ "TSSE", ID3FID_ENCODERSETTINGS,   N_("Software/Hardware and settings used for encoding") },
	{ "TXXX", ID3FID_USERTEXT,          N_("User defined text information") },
	{ "TYER", ID3FID_YEAR,              N_("Year") },
	{ "UFID", ID3FID_UNIQUEFILEID,      N_("Unique file identifier") },
	{ "USER", ID3FID_TERMSOFUSE,        N_("Terms of use") },
	{ "USLT", ID3FID_UNSYNCEDLYRICS,    N_("Unsynchronized lyric/text transcription") },
	{ "WCOM", ID3FID_WWWCOMMERCIALINFO, N_("Commercial information") },
	{ "WCOP", ID3FID_WWWCOPYRIGHT,      N_("Copyright/Legal information") },
	{ "WOAF", ID3FID_WWWAUDIOFILE,      N_("Official audio file webpage") },
	{ "WOAR", ID3FID_WWWARTIST,         N_("Official artist/performer webpage") },
	{ "WOAS", ID3FID_WWWAUDIOSOURCE,    N_("Official audio source webpage") },
	{ "WORS", ID3FID_WWWRADIOPAGE,      N_("Official internet radio station homepage") },
	{ "WPAY", ID3FID_WWWPAYMENT,        N_("Payment") },
	{ "WPUB", ID3FID_WWWPUBLISHER,      N_("Official publisher webpage") },
	{ "WXXX", ID3FID_WWWUSER,           N_("User defined URL link") },
	{ "    ", ID3FID_METACRYPTO,        N_("Encrypted meta frame") },
	{ "    ", ID3FID_METACRYPTO,        N_("Compressed meta frame") },
	{ NULL }
};

#endif // __LIST_ID3FRAMES_H__
