#define  JPEG_IMAGES
#include "SDL.h"
#include "picinfo.h"
#include "SDL_image.h"

void im_sdl_surface_to_picinfo(SDL_Surface* surface, PICINFO* pic)
{
  int   i;
  byte  *pixels,r,g,b;
  int   red_dx,green_dx,blue_dx;

  pic->w=surface->w;
  pic->h=surface->h;

  red_dx  =surface->format->Rshift/8;
  green_dx=surface->format->Gshift/8;
  blue_dx =surface->format->Bshift/8;

  if(surface->format->BytesPerPixel==1)
  {
    pic->type=PIC8;
    pic->pic=(byte*)surface->pixels;
    surface->pixels=0;
    for(i=0;i<256;i++)
    {
      pic->pal[i*3]  =surface->format->palette->colors[i].r;
      pic->pal[i*3+1]=surface->format->palette->colors[i].g;
      pic->pal[i*3+2]=surface->format->palette->colors[i].b;
    }
    SDL_FreeSurface(surface);
  }
  else if(surface->format->BytesPerPixel==4) //32bit
  {
    pixels=(byte*) surface->pixels;
    pic->type=PIC24;
    pic->pic=(byte*) malloc(pic->w*pic->h*3);
    for(i=0;i<pic->w*pic->h;i++)
    {
      pic->pic[i*3+0]=pixels[i*4+red_dx];
      pic->pic[i*3+1]=pixels[i*4+green_dx];
      pic->pic[i*3+2]=pixels[i*4+blue_dx];
    }
    SDL_FreeSurface(surface);
  } else
  {
    pic->type=PIC24;
    pic->pic=(byte*)surface->pixels;
    surface->pixels=0;
    SDL_FreeSurface(surface);
    if(red_dx!=0 || green_dx!=1)
    {
      for(i=0;i<pic->w*pic->h;i++)
      {
	r=pic->pic[i*3+red_dx];
	g=pic->pic[i*3+green_dx];
	b=pic->pic[i*3+blue_dx];
	pic->pic[i*3]=r;
	pic->pic[i*3+1]=g;
	pic->pic[i*3+2]=b;
      }
    }
  }  
}

int  im_load_image_through_loader(char* fname, PICINFO* to_pic, 
		   int from_mem_size, 
		   SDL_Surface* (*img_loader)(SDL_RWops*))
{
  SDL_RWops    *rw;
  SDL_Surface  *surface;

  if(!from_mem_size)
    rw=SDL_RWFromFile(fname,"rb");
  else
    rw=SDL_RWFromMem((void*)fname, from_mem_size);

  surface=img_loader(rw);

  SDL_FreeRW(rw);

  im_sdl_surface_to_picinfo(surface,to_pic);

  return 1;
}

/******************************************************************/

int  im_load_gif(char* fname, PICINFO* to_pic, int from_mem_size)
{

  return im_load_image_through_loader(fname,to_pic,
				      from_mem_size,IMG_LoadGIF_RW);
}

int  im_load_jpg(char* fname, PICINFO* to_pic, int from_mem_size)
{

  return im_load_image_through_loader(fname,to_pic,
				      from_mem_size,IMG_LoadJPG_RW);
}

int  im_load_xpm(char* fname, PICINFO* to_pic, int from_mem_size)
{

  return im_load_image_through_loader(fname,to_pic,
				      from_mem_size,IMG_LoadXPM_RW);
}

int  im_load_pcx(char* fname, PICINFO* to_pic, int from_mem_size)
{

  return im_load_image_through_loader(fname,to_pic,
				      from_mem_size,IMG_LoadPCX_RW);
}

int  im_load_tga(char* fname, PICINFO* to_pic, int from_mem_size)
{

  return im_load_image_through_loader(fname,to_pic,
				      from_mem_size,IMG_LoadTGA_RW);
}

int  im_load_png(char* fname, PICINFO* to_pic, int from_mem_size)
{

  return im_load_image_through_loader(fname,to_pic,
				      from_mem_size,IMG_LoadPNG_RW);
}

int  im_load_lbm(char* fname, PICINFO* to_pic, int from_mem_size)
{

  return im_load_image_through_loader(fname,to_pic,
				      from_mem_size,IMG_LoadLBM_RW);
}

int  im_load_bmp(char* fname, PICINFO* to_pic, int from_mem_size)
{

  return im_load_image_through_loader(fname,to_pic,
				      from_mem_size,IMG_LoadBMP_RW);
}

int  im_load_tif(char* fname, PICINFO* to_pic, int from_mem_size)
{

  return im_load_image_through_loader(fname,to_pic,
				      from_mem_size,IMG_LoadTIF_RW);
}


