/* $Id: logic_tree.c,v 1.10 2001/10/20 15:23:55 fygrave Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "xprobe.h"


int do_logic(struct sockaddr_in to) {
    rpack_t *udp_res, *icmpecho_res, *icmpts_res, *icmpam_res,
    *icmpir_res;
    ssize_t hdr_len;
    int retval = -1;

    if ((udp_res = send_udp(to)) == NULL) {
        fprintf(stderr, "Error while sending UDP query. Quiting\n");
        return -1;
    }


/* make some generic calculations */

    hdr_len = (udp_res->ip->ip_hl<<2) + 8;
    
    /* precedence bits check */

    if (((udp_res->ip->ip_tos) & 0xc0) != 0) {

        /* if our ip->tos was 0xf8 we would get:
            0xd8 --> from linux boxes
            0xf8 --> from hpux/aix/??
            0xc0 --> from cisco (may utilize it later
        */    
        tree_message("Cisco IOS 11.x-12.x! Extreme Network Switches.Linux 2.0.x!2.2.x!2.4.x.");

    /* received datagram size check */
        
        if (ntohs(udp_res->ip->ip_len) != (hdr_len + UDP_LEN_ALL)) {
            tree_message("Cisco IOS 11.x-12x! Extreme Network Switches.");

            if (udp_checksum_ver(udp_res) == UDP_CKSUM_ZERO) {
                fin_message("Extreme Network Switches.");
                retval = 1;
            } else {
                fin_message("Cisco IOS 11.x-12.x");
                retval = 2;
            }
            free_res(&udp_res);
            return retval;
        } else {
            /* the whole datagram echo'ed */
            tree_message("Linux kernel 2.0.x!2.2.x!2.4.x! Based.");

            /* ttl test.. abit dodgy (would work precisely in LAN */
            if (udp_res->ip->ip_ttl < 65) {
                free_res(&udp_res);
                fin_message("Linux kernel 2.0.x");
                return 3;
            }
            tree_message("Linux kernel 2.2.x!2.4.x! Based.");
            free_res(&udp_res);
            /* do ICMP ECHO REQUEST test here */
            if ((icmpecho_res = send_icmpecho_req(to)) == NULL) {
                fprintf(stderr, "Error while sending ICMP echo request.");
                fin_message("Linux kernel 2.2.x! 2.4.x! assumed.");
                return 4;
            }
            tree_message("ICMP echo/echo reply are not filtered");

            if (icmpecho_res->ip->ip_id == 0) {
                fin_message("Linux 2.4.x kernel");
                retval = 5;
            } else {
                if (icmpecho_res->ip->ip_off & htons(IP_DF)) {
                    fin_message("Linux 2.4.x kernel");
                    retval = 5;
                } else {
                    fin_message("Linux 2.2.x/2.4.5+ kernel");
                    retval = 6;
                }
            }
        free_res(&icmpecho_res);
        return retval; /* linux type diag done here */
        } /* endif echo'ed dgrm size" */
    } else {
        /* tos doesn't have 0xc0 then... */
        /* amount of echo'ed data check */ 

        switch(ntohs(udp_res->ip->ip_len) - hdr_len - sizeof(struct ip)) {
            case 64:
                tree_message("Sun Solaris 2.3-2.8! HP-UX 11.x!MacOS 7.x-9.x");
                free_res(&udp_res);
                if ((icmpts_res = send_icmpts_req(to)) == NULL) {
                    fin_message("HP-UX 11.x!MacOS 7.x-9.x (no ts response received)");
                    return 9;
                } else {
                    free_res(&icmpts_res);
                    fin_message("Sun Solaris 2.3-2.8");
                    return 10;
                }
                /* UNREACH */
                break;

            case 8:
                break;
            default:
                fin_message("3Com SuperStack II Switch SWNBBSI-CF,11.1.0.00S38\n"
                            "Nokia IPSO 3.2-2.3.1 releng 783-849\n" 
                            "Ricoh Aficio AP4500 Network Laster Printer\n"
                            "Linux 2.0.x/2.2.x/2.4.x\n"
                            "Shiva AccessPort Bridge/Router Software V.2.1.0");
                free_res(&udp_res);
                return 7;
        } /* switch (diff packlen */

        /* other */
        /* ip tocal length integrity check */

        /* XXX: make sure we do it right
         */
        switch (icmp_unreach_lencheck(udp_res)) {
            case ICMPUNREACH_LEN_GT:
                tree_message("IP total length field value is >20 bytes from the original");
                tree_message("*** AIX!BSDI!NetBSD 1.1.x-1.2.x!MacOS X 1.0-1.2");
                if (ip_checksum_ok(udp_res)) {
                    fin_message("AIX");
                    free_res(&udp_res);
                    return 26;
                }
                tree_message("BSDI. NetBSD 1.1.x-1.2.x! MacOS X 1.0-1.2");
                if (udp_res->ip->ip_id != udp_res->orig_ip->ip_id) {
                    fin_message("Little endian BSDI/NetBSD 1.1.x-1.2.x! MacOS X 1.0-1.2");
                    free_res(&udp_res);
                    return 27;
                } else {
                    fin_message("Big endian BSDI/NetBSD 1.1.x-1.2.x MacOS X 1.0-1.2");
                    free_res(&udp_res);
                    return 28;
                }
                /* UNREACH */
                break;
            case ICMPUNREACH_LEN_LS:    
                tree_message("IP total length field value is <20 bytes from the original");
                tree_message("*** OpenBSD 2.6-2.9, Apollo Domain/OS SR 10.4 NFR IDS Appliance");
                tree_message("*** Extreme Networks switch Network Systems Router NS6114 (NSC 6600 Series)");
                tree_message("*** Cabletron Systems SSR 8000 Systems Software Version 3.1 B16");
                switch(udp_checksum_ver(udp_res)) {
                    case UDP_CKSUM_ZERO:
                        fin_message("Extreme Networks switch Network Systems Router NS6114 (NSC 6600 Series)");
                        fin_message("Cabletron Systems SSR 8000 Systems Software Version 3.1 B16");
                        free_res(&udp_res);
                        return 22;
                    case UDP_CKSUM_BAD:
                        fin_message("NFR IDS Appliance");
                        free_res(&udp_res);
                        return 23;
                   case UDP_CKSUM_GOOD:
                        tree_message("OpenBSD 2.6-2.9, Apollo Domain/OS SR 10.4 NFR IDS Appliance");
                        break;
                }

                if (ip_checksum_ok(udp_res)) {
                    fin_message(" OpenBSD 2.6-2.9");
                    free_res(&udp_res);
                    return 24;
                } else {
                    fin_message("Apollo Domain/OS SR 10.4 NFR IDS Appliance");
                    free_res(&udp_res);
                    return 25;
                }
                /* UNREACH */
                break;
            case ICMPUNREACH_LEN_OK:    
                tree_message("IP total length field value is OK");
                if(frag_bits_flipped(udp_res)) {
                    if (frag_bits_flipped(udp_res) == FRAG_BITS_ZERO) {
                        tree_message("Frag bits are zeroed");
                        fin_message("ULTRIX");
                        free_res(&udp_res);
                        return 35;
                    }
                    tree_message("Frag bits are flipped");
                    tree_message("*** FreeBSD 2.2.x - 4.1!NetBSD");
                    if (ip_checksum_ok(udp_res)) {
                        fin_message("FreeBSD 2.2.x - 4.1");
                        free_res(&udp_res);
                        return 12;
                    } else {
                        fin_message("NetBSD");
                        free_res(&udp_res);
                        return 13;
                    }
                } else {
                    /* frags are not flipped */
                    tree_message("Frag bits are OK");
                    if ((icmpecho_res = send_icmpecho_req(to)) == NULL) {
                        fprintf(stderr, "Error while sending ICMP echo request.\n");
                        /* XXX: very generic msg */
                        fin_message("Windows Based.  Open/Net/FreeBSD/DG-UX/HP-UX 10.x etc");
                        free_res(&udp_res);
                        return 14;
                    }
                    if (icmpecho_res->icmp->icmp_code) {
                        tree_message("ICMP code !=0");
                        /* XXX: to be expanded! */
                        if (!(icmpecho_res->ip->ip_off & htons(IP_DF))) {
                            tree_message("DF bit in icmp echo response not echoed");
                            if (icmpecho_res->ip->ip_ttl < 129) {
                                fin_message("Novell (FreeBSD 4.3-current(?)");
                                free_res(&icmpecho_res);
                                free_res(&udp_res);
                                return 29;
                            } else {
                                fin_message("Ultrix!HPUX 10.20(?)");
                                free_res(&icmpecho_res);
                                free_res(&udp_res);
                                return 30;
                            }
                        } /* else */ 
                        tree_message("DF bit in icmp echo response is echoed");
                        if (!(udp_res->ip->ip_off & htons(IP_DF))) {
                            tree_message("DF bit in icmp unreach is not echoed");
                            tree_message("OpenBSD 2.1-2.3,2.4-2.5!NetBSD 1.5, 1.4.1, 1.4!IBM OS/390");
                            if (udp_checksum_ver(udp_res) ==
                                 UDP_CKSUM_ZERO) {
                                fin_message("OpenBSD 2.1-2.3");
                                free_res(&udp_res);
                                free_res(&icmpecho_res);
                                return 31;
                            } else {
                                tree_message("OpenBSD 2.4-2.5!NetBSD"
                                " 1.5, 1.4.1, 1.4!IBM OS/390");
                                if (udp_res->ip->ip_ttl > 64) {
                                    fin_message("OpenBSD 2.4-2.5!NetBSD 1.5, 1.4.1, 1.4");
                                    free_res(&udp_res);
                                    free_res(&icmpecho_res);
                                    return 32;
                                }
                                fin_message("IBM OS/390");
                                free_res(&udp_res);
                                free_res(&icmpecho_res);
                                return 33;
                            }
                        } 
                        free_res(&icmpecho_res);
                        if ((icmpir_res = send_icmpireq_req(to)) == NULL) {
                            fin_message("Unknown Unix (Accuracy dropped)");
                            free_res(&udp_res);
                           return 0; 
                           /* XXX: yellow line here */
                        }
                        tree_message("OpenVMS!HPUX 10.x!DGUX!SunOS4.x");
                        if (((struct ip *)((char *)(udp_res->icmp) + 8))->ip_id !=
                            udp_res->orig_ip->ip_id) {
                            fin_message("OpenVMS with Digital TCP Services");
                            free_res(&icmpir_res);
                            free_res(&udp_res);
                            return 34;
                        }
                        tree_message("IP ID is ok");
                        tree_message("DGUX/HPUX 10.x/OpenVMS with "
                                     "Process Software TCPWare!SunOS4.x");
                        if (!ip_checksum_ok(udp_res)) {
                            fin_message("HPUX 10.x");
                            free_res(&icmpir_res);
                            free_res(&udp_res);
                            return 35;
                        }
                        tree_message("DGUX/OpenVMS with Process Software TCPWare!SunOS4.x");
                            
                        if (udp_checksum_ver(udp_res) == UDP_CKSUM_ZERO) {
                            tree_message("DGUX/Compaq Tru64!SunOS4.x");
                            if (udp_res->ip->ip_ttl > 64) {
                                fin_message("SunOS4.x");
                                free_res(&udp_res);
                                free_res(&icmpecho_res);
                                return 36;
                            }
                            fin_message("DGUX/Compaq Tru64");
                            free_res(&udp_res);
                            free_res(&icmpecho_res);
                            return 37;
                        }
                            
                        free_res(&udp_res);
                        free_res(&icmpir_res);
                        fin_message("OpenVMS with Process Software TCPWare");
                        return 15;
                    } else {
                        tree_message("Microsoft Windows Family TCP stack");
                        if(icmpecho_res->ip->ip_ttl < 33) {
                            fin_message("Windows 95");
                            free_res(&icmpecho_res);
                            return 16;
                        } 
                        tree_message("Other Windows-based OS (ttl: %d)",icmpecho_res->ip->ip_ttl);
                        if (!icmpecho_res->ip->ip_tos) {
                            free_res(&icmpecho_res);
                            fin_message("Windows 2k. SP1, SP2/Windows XP");
                            return 17;
                        }
                        free_res(&icmpecho_res);
                        tree_message("Other Windows-based OS (98/98SE/NTsp3-/NTsp4+)");
                        if ((icmpts_res = send_icmpts_req(to)) == NULL) {
                            tree_message("Windows NTsp3-!Windows NTsp4+");
                            if ((icmpam_res = send_icmpmaskreq_req(to)) == NULL) {
                                fin_message("Windows NTsp4+");
                                return 18;
                            } else {
                                free_res(&icmpam_res);
                                fin_message("Windows NTsp3-");
                                return 19;
                            }
                        } else {
                            tree_message("Windows 98/98SE/ME");
                            free_res(&icmpts_res);
                            if ((icmpam_res = send_icmpmaskreq_req(to)) == NULL) {
                                fin_message("Windows ME");
                                return 20;
                            } else {
                                fin_message("Windows 98/98SE");
                                return 21;
                            }
                        } /* if (send_icmpts_req */

                        /* NOTREACH */
                    }
                } /* if(frag_flipped... */

               /* NOTREACH */
        } /* switch(icmp_unreach.. */
        fin_message("UNKNOWN");
    } /* else (tos) endif */
    free_res(&udp_res);
 
return 1;
}
