/*-
# X-BASED RUBIK'S CUBE(tm)
#
#  RubikP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Rubik */

#ifndef _RubikP_h
#define _RubikP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "Rubik.h"

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)		/* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Position
#define Position POS
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */
#define FULLCIRCLE NUM_DEGREES

#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w->core.hDC,x,y,x+l,y+h)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w->core.hDC,x1,y1,NULL); \
  (void)LineTo(w->core.hDC,x2,y2)
#define CIRCLE(w,r,x,y) if(r>0)(void)Ellipse(w->core.hDC,x-r+1,y-r+1,x+r,y+r)
#define DRAWRECTANGLE(w,c,x,y,l,h) w->rubik.hPen = CreatePen(PS_SOLID, 1, c); \
  w->rubik.hOldPen = (HPEN) SelectObject(w->core.hDC, w->rubik.hPen); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->rubik.hOldPen); \
  (void) DeleteObject(w->rubik.hPen)
#define FILLRECTANGLE2(w,c,cl,x,y,l,h) w->rubik.hPen =\
  CreatePen(PS_SOLID, 1, cl); \
  w->rubik.hOldPen = (HPEN) SelectObject(w->core.hDC, w->rubik.hPen); \
  w->rubik.hBrush = CreateSolidBrush(c); \
  w->rubik.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->rubik.hBrush); \
  RECTANGLE(w,x,y,(l)+1,(h)+1); \
  (void) SelectObject(w->core.hDC, w->rubik.hOldBrush); \
  (void) DeleteObject(w->rubik.hBrush); \
  (void) SelectObject(w->core.hDC, w->rubik.hOldPen); \
  (void) DeleteObject(w->rubik.hPen)
#define FILLRECTANGLE(w,c,x,y,l,h) w->rubik.hPen = CreatePen(PS_SOLID, 1, c); \
  w->rubik.hOldPen = (HPEN) SelectObject(w->core.hDC, w->rubik.hPen); \
  w->rubik.hBrush = CreateSolidBrush(c); \
  w->rubik.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->rubik.hBrush); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->rubik.hOldBrush); \
  (void) DeleteObject(w->rubik.hBrush); \
  (void) SelectObject(w->core.hDC, w->rubik.hOldPen); \
  (void) DeleteObject(w->rubik.hPen)
#define DRAWLINE(w,c,x1,y1,x2,y2) w->rubik.hPen = CreatePen(PS_SOLID, 1, c); \
  w->rubik.hOldPen = (HPEN) SelectObject(w->core.hDC, w->rubik.hPen); \
  LINE(w,x1,y1,((y1==y2)?1:0)+x2,((x1==x2)?1:0)+y2); \
  (void) SelectObject(w->core.hDC, w->rubik.hOldPen); \
  (void) DeleteObject(w->rubik.hPen)
#define DRAWCIRCLE(w,c,d,x,y) w->rubik.hPen = CreatePen(PS_SOLID, 1, c); \
  w->rubik.hOldPen = (HPEN) SelectObject(w->core.hDC, w->rubik.hPen); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->rubik.hOldPen); \
  (void) DeleteObject(w->rubik.hPen)
#define FILLCIRCLE(w,c,d,x,y) w->rubik.hPen = CreatePen(PS_SOLID, 1, c); \
  w->rubik.hOldPen = (HPEN) SelectObject(w->core.hDC, w->rubik.hPen); \
  w->rubik.hBrush = CreateSolidBrush(c); \
  w->rubik.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->rubik.hBrush); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->rubik.hOldBrush); \
  (void) DeleteObject(w->rubik.hBrush); \
  (void) SelectObject(w->core.hDC, w->rubik.hOldPen); \
  (void) DeleteObject(w->rubik.hPen)
#define DRAWTEXT(w,c,x,y,s,l) (void) SetTextColor(w->core.hDC, c); \
  (void) SetBkMode(w->core.hDC, TRANSPARENT); \
  (void) TextOut(w->core.hDC, (x)-3, (y)-11, (LPCSTR) s, l)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include "Rubik.h"

#ifndef Point
#define Point XPoint
#endif
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define DRAWLINE(w,c,i,j,k,l) XDrawLine(XtDisplay(w),XtWindow(w),\
  c,i,j,k,l)
#define FILLRECTANGLE2(w,c,cl,i,j,l,h) XFillRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h); \
  XDrawRectangle(XtDisplay(w),XtWindow(w),cl,i,j,l,h)
#define FILLRECTANGLE(w,c,i,j,l,h) XFillRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define DRAWRECTANGLE(w,c,i,j,l,h) XDrawRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define FILLCIRCLE(w,c,d,x,y) if(d>0) XFillArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWCIRCLE(w,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWTEXT(w,c,x,y,s,l) (void) XDrawString(XtDisplay(w),XtWindow(w),\
  c,x,y,s,l)
#define POLYGON(w,c,lc,l,n,o) XFillPolygon(XtDisplay(w), XtWindow(w), c, \
  l, n, Convex, (o) ? CoordModeOrigin : CoordModePrevious); \
  XDrawLines(XtDisplay(w), XtWindow(w), lc, \
  l, (n)+1,(o) ? CoordModeOrigin : CoordModePrevious)
#define POLYLINE(w,c,l,n,o) XDrawLines(XtDisplay(w), XtWindow(w), c, \
  l, n,(o) ? CoordModeOrigin : CoordModePrevious)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _RubikClassPart {
	int         ignore;
} RubikClassPart;

typedef struct _RubikClassRec {
	CoreClassPart core_class;
	RubikClassPart rubik_class;
} RubikClassRec;

extern RubikClassRec rubikClassRec;
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define MAXMAXSIZE (MAX(w->rubik.sizex,MAX(w->rubik.sizey,w->rubik.sizez)))
#define MAXTURNINC 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand48
#define LRAND lrand48
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _RubikLoc {
	char        face, rotation;
} RubikLoc;

typedef struct _RubikPart {
	RubikLoc   *cubeLoc[MAXFACES];
	RubikLoc   *rowLoc[MAXORIENT];
	int         currentFace, currentPosition, currentDirection, currentFast;
	Boolean     currentControl;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         delay;
	int         sizex, sizey, sizez;
	int         degreeTurn;
	Position    delta;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        username[81];
	char        faceChar[MAXFACES];
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
#else
	int         menu;
	char       *username, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} RubikPart;

typedef struct _RubikRec {
	CorePart    core;
	RubikPart   rubik;
} RubikRec;

typedef struct _RowNext {
	int         face, direction, sideFace;
} RowNext;

extern RubikLoc *startLoc[MAXFACES];

extern void HideRubik(
#ifdef WINVER
const RubikWidget w
#else
RubikWidget w, XEvent * event, char **args, int nArgs
#endif
);
extern void SelectRubik(RubikWidget w
#ifdef WINVER
, const int x, const int y, const int control
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void ReleaseRubik(RubikWidget w
#ifdef WINVER
, const int x, const int y, const int control
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void PracticeRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void PracticeRubikMaybe(RubikWidget w
, XEvent * event, char **args, int nArgs
);
extern void PracticeRubik2(RubikWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void RandomizeRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void RandomizeRubikMaybe(RubikWidget w
, XEvent * event, char **args, int nArgs
);
extern void RandomizeRubik2(RubikWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void GetRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void WriteRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void ClearRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void UndoRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void SolveRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void OrientizeRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void DecrementRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void IncrementRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void IncrementXRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void IncrementYRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void IncrementZRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void EnterRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void LeaveRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);

#ifdef WINVER
extern void POLYGON(RubikWidget w, GC color, GC lineColor, const POINT * poly,
	int n, Boolean origin);
extern void POLYLINE(RubikWidget w, GC color, const POINT * poly,
	int n, Boolean origin);
extern void DestroyRubik(HBRUSH brush);
extern void ResizeRubik(RubikWidget w);
extern void SizeRubik(RubikWidget w);
extern void InitializeRubik(RubikWidget w, HBRUSH brush);
extern void ExposeRubik(const RubikWidget w);
extern void IncrementAxisRubik(RubikWidget w, char axis);
extern void DimRubik(RubikWidget w);
extern int  MoveRubikDir(RubikWidget w, const int direction);
extern void SetRubikMove(RubikWidget w, int reason, int face, int position,
	int direction, Boolean control, int fast);
#else
extern void QuitRubik(RubikWidget w, XEvent * event, char **args, int nArgs);
extern void MoveRubikCw(RubikWidget w, XEvent * event, char **args, int nArgs);
extern void MoveRubikCcw(RubikWidget w, XEvent * event, char **args,
	int nArgs);
#endif

extern void MoveRubikInput(RubikWidget w,
	int x, int y, int direction, int control);
extern void SetRubik(RubikWidget w, int reason);
extern void MoveRubik(RubikWidget w,
	const int face, const int position, const int direction,
	const Boolean control, int fast);
extern void MoveRubikDelay(RubikWidget w,
	const int face, const int position, const int direction,
	const Boolean control);
#if (!defined(WINVER) || (WINVER <= 0x030a))
extern void Sleep(unsigned int cMilliseconds);
#endif
extern void SetAllColors(RubikWidget w);
extern void ResetPieces(RubikWidget w);
extern void SolveSomePieces(RubikWidget w);
extern void DrawAllPieces(const RubikWidget w);
extern Boolean CheckSolved(const RubikWidget w, Boolean rotation);
extern void InitMoves(void);
extern void PutMove(int face, int position, int direction, int control);
extern void GetMove(int *face, int *position, int *direction, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(RubikWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, RubikWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, RubikWidget w);
extern void PrintStartPosition(FILE * fp, RubikWidget w);
extern void SetStartPosition(RubikWidget w);
extern void faceSizes(const RubikWidget w, const int face, int *sizeOfRow, int *sizeOfColumn);
extern int  sizeFace(const RubikWidget w, const int face);
extern int  sizeRow(const RubikWidget w, const int face);

#ifdef DEBUG
extern void PrintCube(const RubikWidget w);
extern void PrintRow(const RubikWidget w, const int orient, const int size);

#endif

#endif /* _RubikP_h */
