// file      : xsde/cxx/serializer/elements.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/serializer/elements.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace serializer
    {
      // serializer_base
      //
      serializer_base::
      ~serializer_base ()
      {
      }

      void serializer_base::
      _pre ()
      {
      }

      void serializer_base::
      _serialize_attributes ()
      {
      }

      void serializer_base::
      _serialize_content ()
      {
      }

      void serializer_base::
      _post ()
      {
      }

      void serializer_base::
      post ()
      {
      }

      void serializer_base::
      _pre_impl (context& c)
      {
        ++depth_;
        context_ = &c;

        _pre ();
      }

      void serializer_base::
      _post_impl ()
      {
        _post ();

        if (--depth_ == 0)
          context_ = 0;
      }

#ifndef XSDE_EXCEPTIONS
      void serializer_base::
      _copy_error (context& ctx) const
      {
        switch (error_type_)
        {
        case error_app:
          {
            ctx.app_error (error_code_.app);
            break;
          }
        case error_sys:
          {
            ctx.sys_error (error_code_.sys);
            break;
          }
        default:
          break;
        }
      }
#endif
    }
  }
}
